/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.owlapi.explanation.util.DefinitionTracker;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public abstract class SingleExplanationGeneratorImpl
implements TransactionAwareSingleExpGen {
    private boolean inTransaction;
    private final OWLOntologyManager owlOntologyManager;
    private final OWLOntology ontology;
    private final OWLReasoner reasoner;
    private final OWLReasonerFactory reasonerFactory;
    private final DefinitionTracker definitionTracker;

    public SingleExplanationGeneratorImpl(OWLOntology ontology, OWLReasonerFactory reasonerFactory, OWLReasoner reasoner) {
        this.ontology = ontology;
        this.reasonerFactory = reasonerFactory;
        this.reasoner = reasoner;
        this.owlOntologyManager = ontology.getOWLOntologyManager();
        this.definitionTracker = new DefinitionTracker(ontology);
    }

    public OWLOntologyManager getOntologyManager() {
        return this.owlOntologyManager;
    }

    public OWLReasoner getReasoner() {
        return this.reasoner;
    }

    public DefinitionTracker getDefinitionTracker() {
        return this.definitionTracker;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLReasonerFactory getReasonerFactory() {
        return this.reasonerFactory;
    }

    protected boolean isFirstExplanation() {
        return !this.inTransaction;
    }

    public void beginTransaction() {
        if (this.inTransaction) {
            throw new RuntimeException("Already in transaction");
        }
        this.inTransaction = true;
    }

    public void endTransaction() {
        if (!this.inTransaction) {
            throw new RuntimeException("Cannot end transaction");
        }
        this.inTransaction = false;
    }
}

