/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.modularity.locality;

import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.LocalityEvaluator;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntacticLocalityEvaluator
implements LocalityEvaluator {
    protected final LocalityClass localityCls;
    private final AxiomLocalityVisitor axiomVisitor;
    private static final EnumSet<LocalityClass> supportedLocalityClasses = EnumSet.of(LocalityClass.TOP_BOTTOM, LocalityClass.BOTTOM_BOTTOM, LocalityClass.TOP_TOP);

    public SyntacticLocalityEvaluator(LocalityClass localityClass) {
        this.localityCls = localityClass;
        this.axiomVisitor = new AxiomLocalityVisitor();
        if (!supportedLocalityClasses.contains((Object)localityClass)) {
            throw new RuntimeException("Unsupported locality class: " + (Object)((Object)localityClass));
        }
    }

    public Set<LocalityClass> supportedLocalityClasses() {
        return supportedLocalityClasses;
    }

    protected static boolean isTopOrBuiltInDatatype(OWLDataRange dataRange) {
        if (dataRange.isDatatype()) {
            OWLDatatype dataType = dataRange.asOWLDatatype();
            return dataType.isTopDatatype() || dataType.isBuiltIn();
        }
        return false;
    }

    protected static boolean isTopOrBuiltInInfiniteDatatype(OWLDataRange dataRange) {
        if (dataRange.isDatatype()) {
            OWLDatatype dataType = dataRange.asOWLDatatype();
            return dataType.isTopDatatype() || dataType.isBuiltIn() && !dataType.getBuiltInDatatype().isFinite();
        }
        return false;
    }

    @Override
    public boolean isLocal(OWLAxiom axiom, Set<? extends OWLEntity> signature) {
        return this.axiomVisitor.isLocal(axiom, signature);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopEquivalenceEvaluator
    implements OWLClassExpressionVisitor {
        private BottomEquivalenceEvaluator bottomEvaluator;
        private boolean isTopEquivalent;
        private LocalityClass localityCls;
        private Collection<? extends OWLEntity> signature;

        private boolean isTopEquivalent(OWLClassExpression desc) {
            desc.accept(this);
            return this.isTopEquivalent;
        }

        public boolean isTopEquivalent(OWLClassExpression desc, Collection<? extends OWLEntity> signature, LocalityClass localityCls) {
            this.localityCls = localityCls;
            this.signature = signature;
            desc.accept(this);
            return this.isTopEquivalent;
        }

        public void setBottomEvaluator(BottomEquivalenceEvaluator evaluator) {
            this.bottomEvaluator = evaluator;
        }

        @Override
        public void visit(OWLClass desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: {
                    this.isTopEquivalent = desc.isOWLThing();
                    break;
                }
                case TOP_BOTTOM: 
                case TOP_TOP: {
                    this.isTopEquivalent = desc.isOWLThing() || !desc.isOWLNothing() && !this.signature.contains(desc);
                }
            }
        }

        @Override
        public void visit(OWLDataAllValuesFrom desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) || ((OWLDataRange)desc.getFiller()).isTopDatatype();
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = ((OWLDataRange)desc.getFiller()).isTopDatatype();
                }
            }
        }

        @Override
        public void visit(OWLDataExactCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = desc.getCardinality() == 0 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLDataMaxCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLDataMinCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = desc.getCardinality() == 0;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = desc.getCardinality() == 0 || desc.getCardinality() == 1 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)desc.getFiller()) || desc.getCardinality() > 1 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInInfiniteDatatype((OWLDataRange)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLDataSomeValuesFrom desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLDataHasValue desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                }
            }
        }

        @Override
        public void visit(OWLObjectAllValuesFrom desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.isTopEquivalent((OWLClassExpression)desc.getFiller());
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = this.isTopEquivalent((OWLClassExpression)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectComplementOf desc) {
            this.isTopEquivalent = this.bottomEvaluator.isBottomEquivalent(desc.getOperand(), this.signature, this.localityCls);
        }

        @Override
        public void visit(OWLObjectExactCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = desc.getCardinality() == 0 && (!this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.bottomEvaluator.isBottomEquivalent((OWLClassExpression)desc.getFiller(), this.signature, this.localityCls));
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = desc.getCardinality() == 0 && this.bottomEvaluator.isBottomEquivalent((OWLClassExpression)desc.getFiller(), this.signature, this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression conj : desc.getOperands()) {
                if (this.isTopEquivalent(conj)) continue;
                this.isTopEquivalent = false;
                return;
            }
            this.isTopEquivalent = true;
        }

        @Override
        public void visit(OWLObjectMaxCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.bottomEvaluator.isBottomEquivalent((OWLClassExpression)desc.getFiller(), this.signature, this.localityCls);
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = this.bottomEvaluator.isBottomEquivalent((OWLClassExpression)desc.getFiller(), this.signature, this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLObjectMinCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = desc.getCardinality() == 0;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = desc.getCardinality() == 0 || !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) && this.isTopEquivalent((OWLClassExpression)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectOneOf desc) {
            this.isTopEquivalent = false;
        }

        @Override
        public void visit(OWLObjectHasSelf desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty());
                }
            }
        }

        @Override
        public void visit(OWLObjectSomeValuesFrom desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) && this.isTopEquivalent((OWLClassExpression)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectUnionOf desc) {
            for (OWLClassExpression conj : desc.getOperands()) {
                if (!this.isTopEquivalent(conj)) continue;
                this.isTopEquivalent = true;
                return;
            }
            this.isTopEquivalent = false;
        }

        @Override
        public void visit(OWLObjectHasValue desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BottomEquivalenceEvaluator
    implements OWLClassExpressionVisitor {
        private boolean isBottomEquivalent;
        private LocalityClass localityCls;
        private Collection<? extends OWLEntity> signature;
        private TopEquivalenceEvaluator topEvaluator;

        private boolean isBottomEquivalent(OWLClassExpression desc) {
            desc.accept(this);
            return this.isBottomEquivalent;
        }

        public boolean isBottomEquivalent(OWLClassExpression desc, Collection<? extends OWLEntity> signature, LocalityClass localityCls) {
            this.localityCls = localityCls;
            this.signature = signature;
            desc.accept(this);
            return this.isBottomEquivalent;
        }

        public void setTopEvaluator(TopEquivalenceEvaluator evaluator) {
            this.topEvaluator = evaluator;
        }

        @Override
        public void visit(OWLClass desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: {
                    this.isBottomEquivalent = desc.isOWLNothing() || !desc.isOWLThing() && !this.signature.contains(desc);
                    break;
                }
                case TOP_BOTTOM: 
                case TOP_TOP: {
                    this.isBottomEquivalent = desc.isOWLNothing();
                }
            }
        }

        @Override
        public void visit(OWLDataAllValuesFrom desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) && !((OWLDataRange)desc.getFiller()).isTopDatatype();
                }
            }
        }

        @Override
        public void visit(OWLDataExactCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = desc.getCardinality() == 0 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)desc.getFiller()) || desc.getCardinality() > 0 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInInfiniteDatatype((OWLDataRange)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLDataMaxCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = desc.getCardinality() == 0 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)desc.getFiller()) || desc.getCardinality() == 1 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)desc.getFiller()) || desc.getCardinality() > 1 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInInfiniteDatatype((OWLDataRange)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLDataMinCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLDataSomeValuesFrom desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLDataHasValue desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLObjectAllValuesFrom desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) && this.isBottomEquivalent((OWLClassExpression)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectComplementOf desc) {
            this.isBottomEquivalent = this.topEvaluator.isTopEquivalent(desc.getOperand(), this.signature, this.localityCls);
        }

        @Override
        public void visit(OWLObjectExactCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && (!this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.isBottomEquivalent((OWLClassExpression)desc.getFiller()));
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && (this.isBottomEquivalent((OWLClassExpression)desc.getFiller()) || !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) && this.topEvaluator.isTopEquivalent((OWLClassExpression)desc.getFiller(), this.signature, this.localityCls));
                }
            }
        }

        @Override
        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression conj : desc.getOperands()) {
                if (!this.isBottomEquivalent(conj)) continue;
                this.isBottomEquivalent = true;
                return;
            }
            this.isBottomEquivalent = false;
        }

        @Override
        public void visit(OWLObjectMaxCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) && this.topEvaluator.isTopEquivalent((OWLClassExpression)desc.getFiller(), this.signature, this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLObjectMinCardinality desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && (!this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.isBottomEquivalent((OWLClassExpression)desc.getFiller()));
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = desc.getCardinality() > 0 && this.isBottomEquivalent((OWLClassExpression)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectOneOf desc) {
            this.isBottomEquivalent = desc.getIndividuals().isEmpty();
        }

        @Override
        public void visit(OWLObjectHasSelf desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                }
            }
        }

        @Override
        public void visit(OWLObjectSomeValuesFrom desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) || this.isBottomEquivalent((OWLClassExpression)desc.getFiller());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = this.isBottomEquivalent((OWLClassExpression)desc.getFiller());
                }
            }
        }

        @Override
        public void visit(OWLObjectUnionOf desc) {
            for (OWLClassExpression disj : desc.getOperands()) {
                if (this.isBottomEquivalent(disj)) continue;
                this.isBottomEquivalent = false;
                return;
            }
            this.isBottomEquivalent = true;
        }

        @Override
        public void visit(OWLObjectHasValue desc) {
            switch (this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AxiomLocalityVisitor
    implements OWLAxiomVisitor {
        private final BottomEquivalenceEvaluator bottomEvaluator = new BottomEquivalenceEvaluator();
        private boolean isLocal;
        private Collection<? extends OWLEntity> signature;
        private final TopEquivalenceEvaluator topEvaluator = new TopEquivalenceEvaluator();

        public AxiomLocalityVisitor() {
            this.topEvaluator.setBottomEvaluator(this.bottomEvaluator);
            this.bottomEvaluator.setTopEvaluator(this.topEvaluator);
        }

        public boolean isLocal(OWLAxiom axiom, Collection<? extends OWLEntity> signature) {
            this.signature = signature;
            this.isLocal = false;
            axiom.accept(this);
            return this.isLocal;
        }

        @Override
        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            this.isLocal = this.topEvaluator.isTopEquivalent(axiom.getClassExpression(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = false;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
                }
            }
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()) || this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()) || ((OWLDataRange)axiom.getRange()).isTopDatatype();
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = ((OWLDataRange)axiom.getRange()).isTopDatatype();
                }
            }
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getSuperProperty()).asOWLDataProperty());
                }
            }
        }

        @Override
        public void visit(OWLDeclarationAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            Set<OWLClassExpression> disjs = axiom.getClassExpressions();
            int size = disjs.size();
            if (size == 1) {
                this.isLocal = true;
            } else {
                boolean nonBottomEquivDescFound = false;
                for (OWLClassExpression desc : disjs) {
                    if (this.bottomEvaluator.isBottomEquivalent(desc, this.signature, SyntacticLocalityEvaluator.this.localityCls)) continue;
                    if (nonBottomEquivDescFound) {
                        this.isLocal = false;
                        return;
                    }
                    nonBottomEquivDescFound = true;
                }
            }
            this.isLocal = true;
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    Set disjs = axiom.getProperties();
                    int size = disjs.size();
                    if (size == 1) {
                        this.isLocal = true;
                    } else {
                        boolean nonBottomEquivPropFound = false;
                        for (OWLDataPropertyExpression dpe : disjs) {
                            if (!this.signature.contains(dpe.asOWLDataProperty())) continue;
                            if (nonBottomEquivPropFound) {
                                this.isLocal = false;
                                return;
                            }
                            nonBottomEquivPropFound = true;
                        }
                    }
                    this.isLocal = true;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    Set disjs = axiom.getProperties();
                    int size = disjs.size();
                    if (size == 1) {
                        this.isLocal = true;
                    } else {
                        boolean nonBottomEquivPropFound = false;
                        for (OWLObjectPropertyExpression ope : disjs) {
                            if (!this.signature.contains(ope.getNamedProperty())) continue;
                            if (nonBottomEquivPropFound) {
                                this.isLocal = false;
                                return;
                            }
                            nonBottomEquivPropFound = true;
                        }
                    }
                    this.isLocal = true;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            OWLClass lhs = axiom.getOWLClass();
            Set<OWLClassExpression> rhs = axiom.getClassExpressions();
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: {
                    if (!this.signature.contains(lhs)) {
                        for (OWLClassExpression desc : rhs) {
                            if (this.bottomEvaluator.isBottomEquivalent(desc, this.signature, SyntacticLocalityEvaluator.this.localityCls)) continue;
                            this.isLocal = false;
                            return;
                        }
                        this.isLocal = true;
                        break;
                    }
                    this.isLocal = false;
                    break;
                }
                case TOP_BOTTOM: 
                case TOP_TOP: {
                    if (!this.signature.contains(lhs)) {
                        boolean topEquivDescFound = false;
                        for (OWLClassExpression desc : rhs) {
                            if (this.bottomEvaluator.isBottomEquivalent(desc, this.signature, SyntacticLocalityEvaluator.this.localityCls)) continue;
                            if (this.topEvaluator.isTopEquivalent(desc, this.signature, SyntacticLocalityEvaluator.this.localityCls)) {
                                if (topEquivDescFound) {
                                    this.isLocal = false;
                                    return;
                                }
                                topEquivDescFound = true;
                                continue;
                            }
                            this.isLocal = false;
                            return;
                        }
                        this.isLocal = true;
                        break;
                    }
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLAnnotationAssertionAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.isLocal = true;
            Iterator<OWLClassExpression> eqs = axiom.getClassExpressions().iterator();
            OWLClassExpression first = eqs.next();
            if (!eqs.hasNext()) {
                return;
            }
            boolean isBottom = this.bottomEvaluator.isBottomEquivalent(first, this.signature, SyntacticLocalityEvaluator.this.localityCls);
            if (!isBottom && !this.topEvaluator.isTopEquivalent(first, this.signature, SyntacticLocalityEvaluator.this.localityCls)) {
                this.isLocal = false;
            }
            if (isBottom) {
                while (this.isLocal && eqs.hasNext()) {
                    OWLClassExpression next = eqs.next();
                    if (this.bottomEvaluator.isBottomEquivalent(next, this.signature, SyntacticLocalityEvaluator.this.localityCls)) continue;
                    this.isLocal = false;
                }
            } else {
                while (this.isLocal && eqs.hasNext()) {
                    OWLClassExpression next = eqs.next();
                    if (this.topEvaluator.isTopEquivalent(next, this.signature, SyntacticLocalityEvaluator.this.localityCls)) continue;
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            Set eqs = axiom.getProperties();
            int size = eqs.size();
            if (size == 1) {
                this.isLocal = true;
            } else {
                for (OWLDataPropertyExpression p : eqs) {
                    if (!this.signature.contains(p.asOWLDataProperty())) continue;
                    this.isLocal = false;
                    return;
                }
                this.isLocal = true;
            }
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            Set eqs = axiom.getProperties();
            int size = eqs.size();
            if (size == 1) {
                this.isLocal = true;
            } else {
                for (OWLObjectPropertyExpression p : eqs) {
                    if (!this.signature.contains(p.getNamedProperty())) continue;
                    this.isLocal = false;
                    return;
                }
                this.isLocal = true;
            }
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        public void visit(OWLImportsDeclaration axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.isLocal = !this.signature.contains(axiom.getFirstProperty().getNamedProperty()) && !this.signature.contains(axiom.getSecondProperty().getNamedProperty());
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                }
            }
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = false;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                }
            }
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    for (OWLObjectPropertyExpression ope : axiom.getPropertyChain()) {
                        if (this.signature.contains(ope.getNamedProperty())) continue;
                        this.isLocal = true;
                        return;
                    }
                    this.isLocal = false;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.signature.contains(axiom.getSuperProperty().getNamedProperty());
                }
            }
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()) || this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()) || this.topEvaluator.isTopEquivalent((OWLClassExpression)axiom.getRange(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = this.topEvaluator.isTopEquivalent((OWLClassExpression)axiom.getRange(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
                }
            }
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getSubProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getSuperProperty()).getNamedProperty());
                }
            }
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = false;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                }
            }
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            this.isLocal = this.bottomEvaluator.isBottomEquivalent(axiom.getSubClass(), this.signature, SyntacticLocalityEvaluator.this.localityCls) || this.topEvaluator.isTopEquivalent(axiom.getSuperClass(), this.signature, SyntacticLocalityEvaluator.this.localityCls);
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(SWRLRule axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            this.isLocal = true;
        }
    }
}

