/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.SetOntologyID;

public class CreatingOntologies {
    public static void main(String[] args) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            IRI ontologyIRI = IRI.create("http://www.semanticweb.org/ontologies/myontology");
            OWLOntology ontology = manager.createOntology(ontologyIRI);
            System.out.println("Created ontology: " + ontology);
            OWLOntologyID ontologyID = ontology.getOntologyID();
            System.out.println("Ontology IRI: " + ontologyID.getOntologyIRI());
            System.out.println("Ontology Version IRI: " + ontologyID.getVersionIRI());
            System.out.println("Anonymous Ontology: " + ontologyID.isAnonymous());
            System.out.println("--------------------------------------------------------------------------------");
            IRI versionIRI = IRI.create(ontologyIRI + "/version1");
            OWLOntologyID newOntologyID = new OWLOntologyID(ontologyIRI, versionIRI);
            SetOntologyID setOntologyID = new SetOntologyID(ontology, newOntologyID);
            manager.applyChange(setOntologyID);
            System.out.println("Ontology: " + ontology);
            System.out.println("--------------------------------------------------------------------------------");
            IRI ontologyIRI2 = IRI.create("http://www.semanticweb.org/ontologies/myontology2");
            IRI versionIRI2 = IRI.create("http://www.semanticweb.org/ontologies/myontology2/newversion");
            OWLOntologyID ontologyID2 = new OWLOntologyID(ontologyIRI2, versionIRI2);
            OWLOntology ontology2 = manager.createOntology(ontologyID2);
            System.out.println("Created ontology: " + ontology2);
            System.out.println("--------------------------------------------------------------------------------");
            OWLOntology anonOntology = manager.createOntology();
            System.out.println("Created ontology: " + anonOntology);
            System.out.println("Anonymous: " + anonOntology.isAnonymous());
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("Could not create ontology: " + e.getMessage());
        }
    }
}

