/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class Example10 {
    public static final String DOCUMENT_IRI = "http://www.co-ode.org/ontologies/pizza/2007/02/12/pizza.owl";

    public static void main(String[] args) {
        try {
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            OWLOntology ont = man.loadOntologyFromOntologyDocument(IRI.create(DOCUMENT_IRI));
            System.out.println("Loaded: " + ont.getOntologyID());
            OWLDataFactory df = man.getOWLDataFactory();
            OWLClass pizzaCls = df.getOWLClass(IRI.create(ont.getOntologyID().getOntologyIRI().toString() + "#Pizza"));
            OWLAnnotation commentAnno = df.getOWLAnnotation(df.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_COMMENT.getIRI()), df.getOWLLiteral("A class which represents pizzas", "en"));
            OWLAnnotationAssertionAxiom ax = df.getOWLAnnotationAssertionAxiom(pizzaCls.getIRI(), commentAnno);
            man.applyChange(new AddAxiom(ont, ax));
            OWLLiteral lit = df.getOWLLiteral("Added a comment to the pizza class");
            OWLAnnotation anno = df.getOWLAnnotation(df.getOWLAnnotationProperty(OWLRDFVocabulary.OWL_VERSION_INFO.getIRI()), lit);
            man.applyChange(new AddOntologyAnnotation(ont, anno));
            OWLAnnotationProperty label = df.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
            for (OWLClass cls : ont.getClassesInSignature()) {
                for (OWLAnnotation annotation : cls.getAnnotations(ont, label)) {
                    OWLLiteral val;
                    if (!(annotation.getValue() instanceof OWLLiteral) || !(val = (OWLLiteral)annotation.getValue()).hasLang("pt")) continue;
                    System.out.println(cls + " -> " + val.getLiteral());
                }
            }
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("Could not create ontology");
        }
    }
}

