/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.OWLOntologyMerger;

public class Example12 {
    public static void main(String[] args) {
        try {
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            man.loadOntologyFromOntologyDocument(IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl"));
            man.loadOntologyFromOntologyDocument(IRI.create("http://www.co-ode.org/ontologies/amino-acid/2006/05/18/amino-acid.owl"));
            OWLOntologyMerger merger = new OWLOntologyMerger(man);
            IRI mergedOntologyIRI = IRI.create("http://www.semanticweb.com/mymergedont");
            OWLOntology merged = merger.createMergedOntology(man, mergedOntologyIRI);
            for (OWLAxiom ax : merged.getAxioms()) {
                System.out.println(ax);
            }
            man.saveOntology(merged, (OWLOntologyFormat)new RDFXMLOntologyFormat(), IRI.create("file:/tmp/mergedont.owlapi"));
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("Could not load ontology: " + e.getMessage());
        }
        catch (OWLOntologyStorageException e) {
            System.out.println("Problem saving ontology: " + e.getMessage());
        }
    }
}

