/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class Example14 {
    public static void main(String[] args) {
        try {
            IRI documentIRI = IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl");
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            OWLOntology ont = man.loadOntologyFromOntologyDocument(documentIRI);
            String prefix = ont.getOntologyID().getOntologyIRI() + "#";
            OWLReasonerFactory reasonerFactory = null;
            OWLReasoner reasoner = reasonerFactory.createNonBufferingReasoner(ont);
            OWLClass margheritaPizza = man.getOWLDataFactory().getOWLClass(IRI.create(prefix + "Margherita"));
            Example14.printProperties(man, ont, reasoner, margheritaPizza);
            OWLClass vegTopping = man.getOWLDataFactory().getOWLClass(IRI.create(prefix + "JalapenoPepperTopping"));
            Example14.printProperties(man, ont, reasoner, vegTopping);
            OWLClass mozzarellaTopping = man.getOWLDataFactory().getOWLClass(IRI.create(prefix + "MozzarellaTopping"));
            OWLObjectProperty hasOrigin = man.getOWLDataFactory().getOWLObjectProperty(IRI.create(prefix + "hasCountryOfOrigin"));
            if (Example14.hasProperty(man, reasoner, mozzarellaTopping, hasOrigin)) {
                System.out.println("Instances of " + mozzarellaTopping + " have a country of origin");
            }
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("Problem loading ontology: " + e.getMessage());
        }
    }

    private static void printProperties(OWLOntologyManager man, OWLOntology ont, OWLReasoner reasoner, OWLClass cls) {
        if (!ont.containsClassInSignature(cls.getIRI())) {
            throw new RuntimeException("Class not in signature of the ontology");
        }
        System.out.println("----------------------------------------------------------");
        System.out.println("Properties of " + cls);
        System.out.println("----------------------------------------------------------");
        for (OWLObjectProperty prop : ont.getObjectPropertiesInSignature()) {
            boolean sat = Example14.hasProperty(man, reasoner, cls, prop);
            if (!sat) continue;
            System.out.println("Instances of " + cls + " necessarily have the property " + prop);
        }
    }

    private static boolean hasProperty(OWLOntologyManager man, OWLReasoner reasoner, OWLClass cls, OWLObjectPropertyExpression prop) {
        OWLDataFactory dataFactory = man.getOWLDataFactory();
        OWLObjectSomeValuesFrom restriction = dataFactory.getOWLObjectSomeValuesFrom(prop, dataFactory.getOWLThing());
        OWLObjectComplementOf complement = dataFactory.getOWLObjectComplementOf(restriction);
        OWLObjectIntersectionOf intersection = dataFactory.getOWLObjectIntersectionOf(cls, complement);
        return !reasoner.isSatisfiable(intersection);
    }
}

