/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import java.io.File;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.AutoIRIMapper;
import org.semanticweb.owlapi.util.SimpleIRIMapper;

public class Example15 {
    private static IRI MGED_ONTOLOGY_IRI = IRI.create("http://mged.sourceforge.net/ontologies/MGEDOntology.owl");
    private static IRI PROTEGE_ONTOLOGY_IRI = IRI.create("http://protege.stanford.edu/plugins/owl/protege");
    private static IRI TONES_REPOSIITORY_IRI = IRI.create("http://owl.cs.manchester.ac.uk/repository/download");

    public static void main(String[] args) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            OWLOntology ontology = manager.loadOntology(MGED_ONTOLOGY_IRI);
            Example15.printOntologyAndImports(manager, ontology);
            IRI protegeOntologyDocumentIRI = Example15.getTONESRepositoryDocumentIRI(PROTEGE_ONTOLOGY_IRI);
            SimpleIRIMapper iriMapper = new SimpleIRIMapper(PROTEGE_ONTOLOGY_IRI, protegeOntologyDocumentIRI);
            System.out.println();
            System.out.println();
            OWLOntologyManager manager2 = OWLManager.createOWLOntologyManager();
            manager2.addIRIMapper(iriMapper);
            OWLOntology ontology2 = manager2.loadOntology(MGED_ONTOLOGY_IRI);
            Example15.printOntologyAndImports(manager2, ontology2);
            File file = new File("/tmp");
            AutoIRIMapper autoIRIMapper = new AutoIRIMapper(file, false);
            manager2.addIRIMapper(autoIRIMapper);
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }

    private static void printOntologyAndImports(OWLOntologyManager manager, OWLOntology ontology) {
        System.out.println("Loaded ontology:");
        Example15.printOntology(manager, ontology);
        for (OWLOntology importedOntology : ontology.getImports()) {
            System.out.println("Imports:");
            Example15.printOntology(manager, importedOntology);
        }
    }

    private static void printOntology(OWLOntologyManager manager, OWLOntology ontology) {
        IRI ontologyIRI = ontology.getOntologyID().getOntologyIRI();
        IRI documentIRI = manager.getOntologyDocumentIRI(ontology);
        System.out.println(ontologyIRI.toQuotedString());
        System.out.println("    from " + documentIRI.toQuotedString());
    }

    private static IRI getTONESRepositoryDocumentIRI(IRI ontologyIRI) {
        StringBuilder sb = new StringBuilder();
        sb.append(TONES_REPOSIITORY_IRI);
        sb.append("?ontology=");
        sb.append(ontologyIRI);
        return IRI.create(sb.toString());
    }
}

