/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import java.util.HashSet;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.reasoner.structural.StructuralReasoner;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;
import uk.ac.manchester.cs.owlapi.modularity.SyntacticLocalityModuleExtractor;

public class Example16 {
    public static final String DOCUMENT_IRI = "http://www.co-ode.org/ontologies/pizza/2007/02/12/pizza.owl";

    public static void main(String[] args) {
        try {
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            OWLOntology ont = man.loadOntologyFromOntologyDocument(IRI.create(DOCUMENT_IRI));
            System.out.println("Loaded: " + ont.getOntologyID());
            OWLDataFactory df = man.getOWLDataFactory();
            OWLClass toppingCls = df.getOWLClass(IRI.create(ont.getOntologyID().getOntologyIRI().toString() + "#PizzaTopping"));
            HashSet<OWLClass> sig = new HashSet<OWLClass>();
            sig.add(toppingCls);
            HashSet<OWLEntity> seedSig = new HashSet<OWLEntity>();
            StructuralReasoner reasoner = new StructuralReasoner(ont, new SimpleConfiguration(), BufferingMode.NON_BUFFERING);
            for (OWLEntity oWLEntity : sig) {
                seedSig.add(oWLEntity);
                if (!OWLClass.class.isAssignableFrom(oWLEntity.getClass())) continue;
                NodeSet<OWLClass> subClasses = reasoner.getSubClasses((OWLClass)oWLEntity, false);
                seedSig.addAll(subClasses.getFlattened());
            }
            System.out.println();
            System.out.println("Extracting the module for the seed signature consisting of the following entities:");
            for (OWLEntity oWLEntity : seedSig) {
                System.out.println("  " + oWLEntity);
            }
            System.out.println();
            System.out.println("Some statistics of the original ontology:");
            System.out.println("  " + ont.getSignature(true).size() + " entities");
            System.out.println("  " + ont.getLogicalAxiomCount() + " logical axioms");
            System.out.println("  " + (ont.getAxiomCount() - ont.getLogicalAxiomCount()) + " other axioms");
            System.out.println();
            SyntacticLocalityModuleExtractor sme = new SyntacticLocalityModuleExtractor(man, ont, ModuleType.STAR);
            IRI iRI = IRI.create("file:/tmp/PizzaToppingModule.owl");
            OWLOntology mod = sme.extractAsOntology(seedSig, iRI);
            System.out.println("Some statistics of the module:");
            System.out.println("  " + mod.getSignature(true).size() + " entities");
            System.out.println("  " + mod.getLogicalAxiomCount() + " logical axioms");
            System.out.println("  " + (mod.getAxiomCount() - mod.getLogicalAxiomCount()) + " other axioms");
            System.out.println();
            System.out.println("Saving the module as " + mod.getOntologyID().getOntologyIRI() + " .");
            man.saveOntology(mod);
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("Could not create ontology.");
        }
        catch (OWLOntologyStorageException e) {
            System.out.println("Could not save ontology.");
        }
    }
}

