/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.SimpleIRIMapper;

public class Example2 {
    public static void main(String[] args) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            IRI ontologyIRI = IRI.create("http://www.co-ode.org/ontologies/testont.owl");
            IRI documentIRI = IRI.create("file:/tmp/MyOnt.owl");
            SimpleIRIMapper mapper = new SimpleIRIMapper(ontologyIRI, documentIRI);
            manager.addIRIMapper(mapper);
            OWLOntology ontology = manager.createOntology(ontologyIRI);
            OWLDataFactory factory = manager.getOWLDataFactory();
            OWLClass clsA = factory.getOWLClass(IRI.create(ontologyIRI + "#A"));
            OWLClass clsB = factory.getOWLClass(IRI.create(ontologyIRI + "#B"));
            OWLSubClassOfAxiom axiom = factory.getOWLSubClassOfAxiom(clsA, clsB);
            AddAxiom addAxiom = new AddAxiom(ontology, axiom);
            manager.applyChange(addAxiom);
            for (OWLClass cls : ontology.getClassesInSignature()) {
                System.out.println("Referenced class: " + cls);
            }
            Set<OWLClassExpression> superClasses = clsA.getSuperClasses(ontology);
            System.out.println("Asserted superclasses of " + clsA + ":");
            for (OWLClassExpression desc : superClasses) {
                System.out.println(desc);
            }
            manager.saveOntology(ontology);
        }
        catch (OWLException e) {
            e.printStackTrace();
        }
    }
}

