/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import java.util.Collections;
import java.util.HashSet;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.SimpleIRIMapper;

public class Example3 {
    public static void main(String[] args) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            IRI ontologyIRI = IRI.create("http://www.co-ode.org/ontologies/testont.owl");
            IRI documentIRI = IRI.create("file:/tmp/SWRLTest.owl");
            SimpleIRIMapper mapper = new SimpleIRIMapper(ontologyIRI, documentIRI);
            manager.addIRIMapper(mapper);
            OWLOntology ontology = manager.createOntology(ontologyIRI);
            OWLDataFactory factory = manager.getOWLDataFactory();
            OWLClass clsA = factory.getOWLClass(IRI.create(ontologyIRI + "#A"));
            OWLClass clsB = factory.getOWLClass(IRI.create(ontologyIRI + "#B"));
            SWRLVariable var = factory.getSWRLVariable(IRI.create(ontologyIRI + "#x"));
            SWRLRule rule = factory.getSWRLRule(Collections.singleton(factory.getSWRLClassAtom(clsA, var)), Collections.singleton(factory.getSWRLClassAtom(clsB, var)));
            manager.applyChange(new AddAxiom(ontology, rule));
            OWLObjectProperty prop = factory.getOWLObjectProperty(IRI.create(ontologyIRI + "#propA"));
            OWLObjectProperty propB = factory.getOWLObjectProperty(IRI.create(ontologyIRI + "#propB"));
            SWRLObjectPropertyAtom propAtom = factory.getSWRLObjectPropertyAtom(prop, var, var);
            SWRLObjectPropertyAtom propAtom2 = factory.getSWRLObjectPropertyAtom(propB, var, var);
            HashSet<SWRLObjectPropertyAtom> antecedent = new HashSet<SWRLObjectPropertyAtom>();
            antecedent.add(propAtom);
            antecedent.add(propAtom2);
            SWRLRule rule2 = factory.getSWRLRule(antecedent, Collections.singleton(propAtom));
            manager.applyChange(new AddAxiom(ontology, rule2));
            manager.saveOntology(ontology);
        }
        catch (OWLException e) {
            e.printStackTrace();
        }
    }
}

