/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class Example7 {
    public static void main(String[] args) {
        try {
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            String base = "http://org.semanticweb.datarangeexample";
            OWLOntology ont = man.createOntology(IRI.create(base));
            OWLDataFactory factory = man.getOWLDataFactory();
            OWLDataProperty hasAge = factory.getOWLDataProperty(IRI.create(base + "hasAge"));
            OWLFunctionalDataPropertyAxiom funcAx = factory.getOWLFunctionalDataPropertyAxiom(hasAge);
            man.applyChange(new AddAxiom(ont, funcAx));
            OWLDatatype intDatatype = factory.getIntegerOWLDatatype();
            OWLLiteral eighteenConstant = factory.getOWLLiteral(18);
            OWLFacet facet = OWLFacet.MIN_INCLUSIVE;
            OWLDatatypeRestriction intGreaterThan18 = factory.getOWLDatatypeRestriction(intDatatype, facet, eighteenConstant);
            OWLDataSomeValuesFrom thingsWithAgeGreaterOrEqualTo18 = factory.getOWLDataSomeValuesFrom(hasAge, intGreaterThan18);
            OWLClass adult = factory.getOWLClass(IRI.create(base + "#Adult"));
            OWLSubClassOfAxiom ax = factory.getOWLSubClassOfAxiom(adult, thingsWithAgeGreaterOrEqualTo18);
            man.applyChange(new AddAxiom(ont, ax));
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }
}

