/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.ConsoleProgressMonitor;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.util.DefaultPrefixManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Example8 {
    public static final String DOCUMENT_IRI = "http://owl.cs.manchester.ac.uk/repository/download?ontology=file:/Users/seanb/Desktop/Cercedilla2005/hands-on/people.owl&format=RDF/XML";
    private static DefaultPrefixManager pm = new DefaultPrefixManager("http://owl.man.ac.uk/2005/07/sssw/people#");

    public static void main(String[] args) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            IRI docIRI = IRI.create(DOCUMENT_IRI);
            OWLOntology ont = manager.loadOntologyFromOntologyDocument(docIRI);
            System.out.println("Loaded " + ont.getOntologyID());
            OWLReasonerFactory reasonerFactory = null;
            ConsoleProgressMonitor progressMonitor = new ConsoleProgressMonitor();
            SimpleConfiguration config = new SimpleConfiguration(progressMonitor);
            OWLReasoner reasoner = reasonerFactory.createReasoner(ont, config);
            reasoner.precomputeInferences(new InferenceType[0]);
            boolean consistent = reasoner.isConsistent();
            System.out.println("Consistent: " + consistent);
            System.out.println("\n");
            Node<OWLClass> bottomNode = reasoner.getUnsatisfiableClasses();
            Set<OWLClass> unsatisfiable = bottomNode.getEntitiesMinusBottom();
            if (!unsatisfiable.isEmpty()) {
                System.out.println("The following classes are unsatisfiable: ");
                for (OWLClass cls : unsatisfiable) {
                    System.out.println("    " + cls);
                }
            } else {
                System.out.println("There are no unsatisfiable classes");
            }
            System.out.println("\n");
            OWLDataFactory fac = manager.getOWLDataFactory();
            OWLClass vegPizza = fac.getOWLClass(IRI.create("http://owl.man.ac.uk/2005/07/sssw/people#vegetarian"));
            NodeSet<OWLClass> subClses = reasoner.getSubClasses(vegPizza, true);
            Set<OWLClass> clses = subClses.getFlattened();
            System.out.println("Subclasses of vegetarian: ");
            for (OWLClass cls : clses) {
                System.out.println("    " + cls);
            }
            System.out.println("\n");
            OWLClass country = fac.getOWLClass(IRI.create("http://owl.man.ac.uk/2005/07/sssw/people#pet"));
            NodeSet<OWLNamedIndividual> individualsNodeSet = reasoner.getInstances(country, true);
            Set<OWLNamedIndividual> individuals = individualsNodeSet.getFlattened();
            System.out.println("Instances of pet: ");
            for (OWLNamedIndividual ind : individuals) {
                System.out.println("    " + ind);
            }
            System.out.println("\n");
            OWLNamedIndividual mick = fac.getOWLNamedIndividual(IRI.create("http://owl.man.ac.uk/2005/07/sssw/people#Mick"));
            OWLObjectProperty hasPet = fac.getOWLObjectProperty(IRI.create("http://owl.man.ac.uk/2005/07/sssw/people#has_pet"));
            NodeSet<OWLNamedIndividual> petValuesNodeSet = reasoner.getObjectPropertyValues(mick, hasPet);
            Set<OWLNamedIndividual> values = petValuesNodeSet.getFlattened();
            System.out.println("The has_pet property values for Mick are: ");
            for (OWLNamedIndividual ind : values) {
                System.out.println("    " + ind);
            }
            Node<OWLClass> topNode = reasoner.getTopClassNode();
            Example8.print(topNode, reasoner, 0);
        }
        catch (UnsupportedOperationException exception) {
            System.out.println("Unsupported reasoner operation.");
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("Could not load the pizza ontology: " + e.getMessage());
        }
    }

    private static void print(Node<OWLClass> parent, OWLReasoner reasoner, int depth) {
        if (parent.isBottomNode()) {
            return;
        }
        Example8.printIndent(depth);
        Example8.printNode(parent);
        for (Node node : reasoner.getSubClasses(parent.getRepresentativeElement(), true)) {
            Example8.print(node, reasoner, depth + 1);
        }
    }

    private static void printIndent(int depth) {
        for (int i = 0; i < depth; ++i) {
            System.out.print("    ");
        }
    }

    private static void printNode(Node<OWLClass> node) {
        System.out.print("{");
        Iterator<OWLClass> it = node.getEntities().iterator();
        while (it.hasNext()) {
            OWLClass cls = it.next();
            System.out.print(pm.getShortForm(cls));
            if (!it.hasNext()) continue;
            System.out.print(" ");
        }
        System.out.println("}");
    }
}

