/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

public class Example9 {
    public static final String DOCUMENT_IRI = "http://www.co-ode.org/ontologies/pizza/2007/02/12/pizza.owl";

    public static void main(String[] args) {
        try {
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            OWLOntology ont = man.loadOntologyFromOntologyDocument(IRI.create(DOCUMENT_IRI));
            System.out.println("Loaded: " + ont.getOntologyID());
            IRI margheritaPizzaIRI = IRI.create(ont.getOntologyID().getOntologyIRI() + "#Margherita");
            OWLClass margheritaPizza = man.getOWLDataFactory().getOWLClass(margheritaPizzaIRI);
            RestrictionVisitor restrictionVisitor = new RestrictionVisitor(Collections.singleton(ont));
            for (OWLSubClassOfAxiom ax : ont.getSubClassAxiomsForSubClass(margheritaPizza)) {
                OWLClassExpression superCls = ax.getSuperClass();
                superCls.accept(restrictionVisitor);
            }
            System.out.println("Restricted properties for " + margheritaPizza + ": " + restrictionVisitor.getRestrictedProperties().size());
            for (OWLObjectPropertyExpression prop : restrictionVisitor.getRestrictedProperties()) {
                System.out.println("    " + prop);
            }
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("Could not load ontology: " + e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RestrictionVisitor
    extends OWLClassExpressionVisitorAdapter {
        private boolean processInherited = true;
        private Set<OWLClass> processedClasses;
        private Set<OWLObjectPropertyExpression> restrictedProperties = new HashSet<OWLObjectPropertyExpression>();
        private Set<OWLOntology> onts;

        public RestrictionVisitor(Set<OWLOntology> onts) {
            this.processedClasses = new HashSet<OWLClass>();
            this.onts = onts;
        }

        public void setProcessInherited(boolean processInherited) {
            this.processInherited = processInherited;
        }

        public Set<OWLObjectPropertyExpression> getRestrictedProperties() {
            return this.restrictedProperties;
        }

        @Override
        public void visit(OWLClass desc) {
            if (this.processInherited && !this.processedClasses.contains(desc)) {
                this.processedClasses.add(desc);
                for (OWLOntology ont : this.onts) {
                    for (OWLSubClassOfAxiom ax : ont.getSubClassAxiomsForSubClass(desc)) {
                        ax.getSuperClass().accept(this);
                    }
                }
            }
        }

        public void reset() {
            this.processedClasses.clear();
            this.restrictedProperties.clear();
        }

        @Override
        public void visit(OWLObjectSomeValuesFrom desc) {
            this.restrictedProperties.add((OWLObjectPropertyExpression)desc.getProperty());
        }
    }
}

