/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Map;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLOntologyCreationIOException;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.UnparsableOntologyException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.SimpleIRIMapper;

public class LoadingOntologies {
    public static void main(String[] args) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            IRI iri = IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl");
            OWLOntology pizzaOntology = manager.loadOntologyFromOntologyDocument(iri);
            System.out.println("Loaded ontology: " + pizzaOntology);
            manager.removeOntology(pizzaOntology);
            File file = new File("/tmp/pizza.owl");
            OWLOntology localPizza = manager.loadOntologyFromOntologyDocument(file);
            System.out.println("Loaded ontology: " + localPizza);
            IRI documentIRI = manager.getOntologyDocumentIRI(localPizza);
            System.out.println("    from: " + documentIRI);
            manager.removeOntology(pizzaOntology);
            manager.addIRIMapper(new SimpleIRIMapper(iri, IRI.create(file)));
            IRI pizzaOntologyIRI = IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl");
            OWLOntology redirectedPizza = manager.loadOntology(pizzaOntologyIRI);
            System.out.println("Loaded ontology: " + redirectedPizza);
            System.out.println("    from: " + manager.getOntologyDocumentIRI(redirectedPizza));
        }
        catch (OWLOntologyCreationIOException e) {
            IOException ioException = e.getCause();
            if (ioException instanceof FileNotFoundException) {
                System.out.println("Could not load ontology. File not found: " + ioException.getMessage());
            } else if (ioException instanceof UnknownHostException) {
                System.out.println("Could not load ontology. Unknown host: " + ioException.getMessage());
            } else {
                System.out.println("Could not load ontology: " + ioException.getClass().getSimpleName() + " " + ioException.getMessage());
            }
        }
        catch (UnparsableOntologyException e) {
            System.out.println("Could not parse the ontology: " + e.getMessage());
            Map<OWLParser, OWLParserException> exceptions = e.getExceptions();
            for (OWLParser parser : exceptions.keySet()) {
                System.out.println("Tried to parse the ontology with the " + parser.getClass().getSimpleName() + " parser");
                System.out.println("Failed because: " + exceptions.get(parser).getMessage());
            }
        }
        catch (UnloadableImportException e) {
            System.out.println("Could not load import: " + e.getImportsDeclaration());
            OWLOntologyCreationException cause = e.getOntologyCreationException();
            System.out.println("Reason: " + cause.getMessage());
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("Could not load ontology: " + e.getMessage());
        }
    }
}

