/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import java.util.HashSet;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.coode.owlapi.turtle.TurtleOntologyFormat;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLUnaryPropertyAxiom;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class OWLPrimer {
    public static void main(String[] args) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            IRI ontologyIRI = IRI.create("http://example.com/owlapi/families");
            OWLOntology ont = manager.createOntology(ontologyIRI);
            OWLDataFactory factory = manager.getOWLDataFactory();
            OWLNamedIndividual john = factory.getOWLNamedIndividual(IRI.create(ontologyIRI + "#John"));
            OWLNamedIndividual mary = factory.getOWLNamedIndividual(IRI.create(ontologyIRI + "#Mary"));
            OWLNamedIndividual susan = factory.getOWLNamedIndividual(IRI.create(ontologyIRI + "#Susan"));
            OWLNamedIndividual bill = factory.getOWLNamedIndividual(IRI.create(ontologyIRI + "#Bill"));
            OWLObjectProperty hasWife = factory.getOWLObjectProperty(IRI.create(ontologyIRI + "#hasWife"));
            OWLObjectPropertyAssertionAxiom axiom1 = factory.getOWLObjectPropertyAssertionAxiom(hasWife, john, mary);
            AddAxiom addAxiom1 = new AddAxiom(ont, axiom1);
            manager.applyChange(addAxiom1);
            OWLObjectProperty hasSon = factory.getOWLObjectProperty(IRI.create(ontologyIRI + "#hasSon"));
            OWLObjectPropertyAssertionAxiom axiom2 = factory.getOWLObjectPropertyAssertionAxiom(hasSon, john, bill);
            manager.applyChange(new AddAxiom(ont, axiom2));
            OWLObjectProperty hasDaughter = factory.getOWLObjectProperty(IRI.create(ontologyIRI + "#hasDaughter"));
            OWLObjectPropertyAssertionAxiom axiom3 = factory.getOWLObjectPropertyAssertionAxiom(hasDaughter, john, susan);
            manager.applyChange(new AddAxiom(ont, axiom3));
            OWLDataProperty hasAge = factory.getOWLDataProperty(IRI.create(ontologyIRI + "#hasAge"));
            OWLDataPropertyAssertionAxiom axiom4 = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)hasAge, (OWLIndividual)john, 33);
            manager.applyChange(new AddAxiom(ont, axiom4));
            OWLDatatype intDatatype = factory.getIntegerOWLDatatype();
            OWLLiteral thirtyThree = factory.getOWLLiteral("33", intDatatype);
            factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)hasAge, (OWLIndividual)john, thirtyThree);
            HashSet<OWLPropertyAssertionAxiom<OWLObjectPropertyExpression, OWLIndividual>> axioms = new HashSet<OWLPropertyAssertionAxiom<OWLObjectPropertyExpression, OWLIndividual>>();
            axioms.add(factory.getOWLObjectPropertyAssertionAxiom(hasSon, mary, bill));
            axioms.add(factory.getOWLObjectPropertyAssertionAxiom(hasDaughter, mary, susan));
            axioms.add(factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)hasAge, (OWLIndividual)mary, 31));
            axioms.add(factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)hasAge, (OWLIndividual)bill, 13));
            axioms.add(factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)hasAge, (OWLIndividual)mary, 8));
            manager.addAxioms(ont, axioms);
            OWLNamedIndividual male = factory.getOWLNamedIndividual(IRI.create(ontologyIRI + "#male"));
            OWLNamedIndividual female = factory.getOWLNamedIndividual(IRI.create(ontologyIRI + "#female"));
            OWLObjectProperty hasGender = factory.getOWLObjectProperty(IRI.create(ontologyIRI + "#hasGender"));
            HashSet<OWLObjectPropertyAssertionAxiom> genders = new HashSet<OWLObjectPropertyAssertionAxiom>();
            genders.add(factory.getOWLObjectPropertyAssertionAxiom(hasGender, john, male));
            genders.add(factory.getOWLObjectPropertyAssertionAxiom(hasGender, mary, female));
            genders.add(factory.getOWLObjectPropertyAssertionAxiom(hasGender, bill, male));
            genders.add(factory.getOWLObjectPropertyAssertionAxiom(hasGender, susan, female));
            manager.addAxioms(ont, genders);
            OWLClass person = factory.getOWLClass(IRI.create(ontologyIRI + "#Person"));
            HashSet<OWLUnaryPropertyAxiom<OWLObjectPropertyExpression>> domainsAndRanges = new HashSet<OWLUnaryPropertyAxiom<OWLObjectPropertyExpression>>();
            domainsAndRanges.add(factory.getOWLObjectPropertyDomainAxiom(hasWife, person));
            domainsAndRanges.add(factory.getOWLObjectPropertyRangeAxiom(hasWife, person));
            domainsAndRanges.add(factory.getOWLObjectPropertyDomainAxiom(hasSon, person));
            domainsAndRanges.add(factory.getOWLObjectPropertyRangeAxiom(hasSon, person));
            domainsAndRanges.add(factory.getOWLObjectPropertyDomainAxiom(hasDaughter, person));
            domainsAndRanges.add(factory.getOWLObjectPropertyRangeAxiom(hasDaughter, person));
            domainsAndRanges.add(factory.getOWLDataPropertyDomainAxiom(hasAge, person));
            OWLDatatype integerDatatype = factory.getIntegerOWLDatatype();
            domainsAndRanges.add(factory.getOWLDataPropertyRangeAxiom(hasAge, integerDatatype));
            manager.addAxioms(ont, domainsAndRanges);
            OWLClassAssertionAxiom classAssertionAx = factory.getOWLClassAssertionAxiom(person, john);
            manager.addAxiom(ont, classAssertionAx);
            OWLObjectProperty hasHusband = factory.getOWLObjectProperty(IRI.create(ont.getOntologyID().getOntologyIRI() + "#hasHusband"));
            manager.addAxiom(ont, factory.getOWLInverseObjectPropertiesAxiom(hasWife, hasHusband));
            OWLObjectProperty hasChild = factory.getOWLObjectProperty(IRI.create(ont.getOntologyID().getOntologyIRI() + "#hasChild"));
            OWLSubObjectPropertyOfAxiom hasSonSubHasChildAx = factory.getOWLSubObjectPropertyOfAxiom(hasSon, hasChild);
            manager.addAxiom(ont, hasSonSubHasChildAx);
            manager.addAxiom(ont, factory.getOWLSubObjectPropertyOfAxiom(hasDaughter, hasChild));
            OWLFunctionalDataPropertyAxiom hasAgeFuncAx = factory.getOWLFunctionalDataPropertyAxiom(hasAge);
            manager.addAxiom(ont, hasAgeFuncAx);
            HashSet<OWLObjectPropertyCharacteristicAxiom> hasWifeAxioms = new HashSet<OWLObjectPropertyCharacteristicAxiom>();
            hasWifeAxioms.add(factory.getOWLFunctionalObjectPropertyAxiom(hasWife));
            hasWifeAxioms.add(factory.getOWLInverseFunctionalObjectPropertyAxiom(hasWife));
            hasWifeAxioms.add(factory.getOWLIrreflexiveObjectPropertyAxiom(hasWife));
            hasWifeAxioms.add(factory.getOWLAsymmetricObjectPropertyAxiom(hasWife));
            manager.addAxioms(ont, hasWifeAxioms);
            OWLClass man = factory.getOWLClass(IRI.create(ontologyIRI + "#Man"));
            OWLClass woman = factory.getOWLClass(IRI.create(ontologyIRI + "#Woman"));
            OWLClass parent = factory.getOWLClass(IRI.create(ontologyIRI + "#Parent"));
            manager.addAxiom(ont, factory.getOWLSubClassOfAxiom(man, person));
            manager.addAxiom(ont, factory.getOWLSubClassOfAxiom(woman, person));
            manager.addAxiom(ont, factory.getOWLSubClassOfAxiom(parent, person));
            OWLDataExactCardinality hasAgeRestriction = factory.getOWLDataExactCardinality(1, hasAge);
            OWLObjectExactCardinality hasGenderRestriction = factory.getOWLObjectExactCardinality(1, hasGender);
            OWLObjectOneOf maleOrFemale = factory.getOWLObjectOneOf(male, female);
            OWLObjectAllValuesFrom hasGenderOnlyMaleFemale = factory.getOWLObjectAllValuesFrom(hasGender, maleOrFemale);
            OWLObjectIntersectionOf intersection = factory.getOWLObjectIntersectionOf(hasAgeRestriction, hasGenderRestriction, hasGenderOnlyMaleFemale);
            manager.addAxiom(ont, factory.getOWLSubClassOfAxiom(person, intersection));
            OWLObjectHasValue hasGenderValueMaleRestriction = factory.getOWLObjectHasValue(hasGender, male);
            OWLObjectIntersectionOf personAndHasGenderValueMale = factory.getOWLObjectIntersectionOf(person, hasGenderValueMaleRestriction);
            manager.addAxiom(ont, factory.getOWLObjectPropertyRangeAxiom(hasSon, personAndHasGenderValueMale));
            OWLObjectIntersectionOf rangeOfHasDaughter = factory.getOWLObjectIntersectionOf(person, factory.getOWLObjectHasValue(hasGender, female));
            manager.addAxiom(ont, factory.getOWLObjectPropertyRangeAxiom(hasDaughter, rangeOfHasDaughter));
            OWLFacetRestriction geq13 = factory.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, factory.getOWLLiteral(13));
            OWLFacetRestriction lt20 = factory.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, 20);
            OWLDatatypeRestriction dataRng = factory.getOWLDatatypeRestriction(integerDatatype, geq13, lt20);
            OWLDataSomeValuesFrom teenagerAgeRestriction = factory.getOWLDataSomeValuesFrom(hasAge, dataRng);
            OWLObjectIntersectionOf teenagePerson = factory.getOWLObjectIntersectionOf(person, teenagerAgeRestriction);
            OWLClass teenager = factory.getOWLClass(IRI.create(ontologyIRI + "#Teenager"));
            OWLEquivalentClassesAxiom teenagerDefinition = factory.getOWLEquivalentClassesAxiom((OWLClassExpression)teenager, (OWLClassExpression)teenagePerson);
            manager.addAxiom(ont, teenagerDefinition);
            OWLDatatypeRestriction geq21 = factory.getOWLDatatypeRestriction(integerDatatype, factory.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, 21));
            OWLClass adult = factory.getOWLClass(IRI.create(ontologyIRI + "#Adult"));
            OWLDataSomeValuesFrom adultAgeRestriction = factory.getOWLDataSomeValuesFrom(hasAge, geq21);
            OWLObjectIntersectionOf adultPerson = factory.getOWLObjectIntersectionOf(person, adultAgeRestriction);
            OWLEquivalentClassesAxiom adultDefinition = factory.getOWLEquivalentClassesAxiom((OWLClassExpression)adult, (OWLClassExpression)adultPerson);
            manager.addAxiom(ont, adultDefinition);
            OWLDataComplementOf notGeq21 = factory.getOWLDataComplementOf(geq21);
            OWLClass child = factory.getOWLClass(IRI.create(ontologyIRI + "#Child"));
            OWLDataSomeValuesFrom childAgeRestriction = factory.getOWLDataSomeValuesFrom(hasAge, notGeq21);
            OWLObjectIntersectionOf childPerson = factory.getOWLObjectIntersectionOf(person, childAgeRestriction);
            OWLEquivalentClassesAxiom childDefinition = factory.getOWLEquivalentClassesAxiom((OWLClassExpression)child, (OWLClassExpression)childPerson);
            manager.addAxiom(ont, childDefinition);
            OWLDifferentIndividualsAxiom diffInds = factory.getOWLDifferentIndividualsAxiom(john, mary, bill, susan);
            manager.addAxiom(ont, diffInds);
            manager.addAxiom(ont, factory.getOWLDifferentIndividualsAxiom(male, female));
            OWLDisjointClassesAxiom disjointClassesAxiom = factory.getOWLDisjointClassesAxiom(man, woman);
            manager.addAxiom(ont, disjointClassesAxiom);
            System.out.println("RDF/XML: -------------------------------------------------------------------------------");
            manager.saveOntology(ont, new StreamDocumentTarget(System.out));
            System.out.println("OWL/XML: -------------------------------------------------------------------------------");
            manager.saveOntology(ont, (OWLOntologyFormat)new OWLXMLOntologyFormat(), new StreamDocumentTarget(System.out));
            System.out.println("Manchester syntax: -------------------------------------------------------------------------------");
            manager.saveOntology(ont, (OWLOntologyFormat)new ManchesterOWLSyntaxOntologyFormat(), new StreamDocumentTarget(System.out));
            System.out.println("Turtle: -------------------------------------------------------------------------------");
            manager.saveOntology(ont, (OWLOntologyFormat)new TurtleOntologyFormat(), new StreamDocumentTarget(System.out));
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("There was a problem creating the ontology: " + e.getMessage());
        }
        catch (OWLOntologyStorageException e) {
            System.out.println("Problem saving ontology: " + e.getMessage());
        }
    }
}

