/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.SystemOutDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class PropertyAssertions {
    public static void main(String[] args) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            IRI ontologyIRI = IRI.create("http://example.com/owl/families/");
            OWLOntology ontology = manager.createOntology(ontologyIRI);
            OWLDataFactory factory = manager.getOWLDataFactory();
            DefaultPrefixManager pm = new DefaultPrefixManager(ontologyIRI.toString());
            OWLNamedIndividual john = factory.getOWLNamedIndividual(":John", pm);
            OWLNamedIndividual mary = factory.getOWLNamedIndividual(":Mary", pm);
            OWLObjectProperty hasWife = factory.getOWLObjectProperty(":hasWife", pm);
            OWLObjectPropertyAssertionAxiom propertyAssertion = factory.getOWLObjectPropertyAssertionAxiom(hasWife, john, mary);
            manager.addAxiom(ontology, propertyAssertion);
            OWLDataProperty hasAge = factory.getOWLDataProperty(":hasAge", pm);
            OWLDataPropertyAssertionAxiom dataPropertyAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)hasAge, (OWLIndividual)john, 51);
            manager.addAxiom(ontology, dataPropertyAssertion);
            OWLDatatype integerDatatype = factory.getOWLDatatype(OWL2Datatype.XSD_INTEGER.getIRI());
            OWLLiteral literal = factory.getOWLLiteral("51", integerDatatype);
            OWLDataPropertyAssertionAxiom ax = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)hasAge, (OWLIndividual)john, literal);
            manager.addAxiom(ontology, ax);
            manager.saveOntology(ontology, new SystemOutDocumentTarget());
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("Could not create ontology: " + e.getMessage());
        }
        catch (OWLOntologyStorageException e) {
            System.out.println("Could not save ontology: " + e.getMessage());
        }
    }
}

