/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples;

import java.io.File;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.io.SystemOutDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;

public class SavingOntologies {
    public static void main(String[] args) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            IRI documentIRI = IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl");
            OWLOntology pizzaOntology = manager.loadOntologyFromOntologyDocument(documentIRI);
            System.out.println("Loaded ontology: " + pizzaOntology);
            File file = new File("/tmp/local.owl");
            manager.saveOntology(pizzaOntology, IRI.create(file.toURI()));
            OWLOntologyFormat format = manager.getOntologyFormat(pizzaOntology);
            System.out.println("    format: " + format);
            OWLXMLOntologyFormat owlxmlFormat = new OWLXMLOntologyFormat();
            if (format.isPrefixOWLOntologyFormat()) {
                owlxmlFormat.copyPrefixesFrom(format.asPrefixOWLOntologyFormat());
            }
            manager.saveOntology(pizzaOntology, (OWLOntologyFormat)owlxmlFormat, IRI.create(file.toURI()));
            SystemOutDocumentTarget documentTarget = new SystemOutDocumentTarget();
            ManchesterOWLSyntaxOntologyFormat manSyntaxFormat = new ManchesterOWLSyntaxOntologyFormat();
            if (format.isPrefixOWLOntologyFormat()) {
                manSyntaxFormat.copyPrefixesFrom(format.asPrefixOWLOntologyFormat());
            }
            manager.saveOntology(pizzaOntology, (OWLOntologyFormat)manSyntaxFormat, new SystemOutDocumentTarget());
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("Could not load ontology: " + e.getMessage());
        }
        catch (OWLOntologyStorageException e) {
            System.out.println("Could not save ontology: " + e.getMessage());
        }
    }
}

