/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples.dlquery;

import java.util.Collections;
import java.util.Set;
import org.coode.owlapi.examples.dlquery.DLQueryParser;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.ShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLQueryEngine {
    private OWLReasoner reasoner;
    private DLQueryParser parser;

    public DLQueryEngine(OWLReasoner reasoner, ShortFormProvider shortFormProvider) {
        this.reasoner = reasoner;
        OWLOntology rootOntology = reasoner.getRootOntology();
        this.parser = new DLQueryParser(rootOntology, shortFormProvider);
    }

    public Set<OWLClass> getSuperClasses(String classExpressionString, boolean direct) throws ParserException {
        if (classExpressionString.trim().length() == 0) {
            return Collections.emptySet();
        }
        OWLClassExpression classExpression = this.parser.parseClassExpression(classExpressionString);
        NodeSet<OWLClass> superClasses = this.reasoner.getSuperClasses(classExpression, direct);
        return superClasses.getFlattened();
    }

    public Set<OWLClass> getEquivalentClasses(String classExpressionString) throws ParserException {
        if (classExpressionString.trim().length() == 0) {
            return Collections.emptySet();
        }
        OWLClassExpression classExpression = this.parser.parseClassExpression(classExpressionString);
        Node<OWLClass> equivalentClasses = this.reasoner.getEquivalentClasses(classExpression);
        Set<OWLClass> result = classExpression.isAnonymous() ? equivalentClasses.getEntities() : equivalentClasses.getEntitiesMinus(classExpression.asOWLClass());
        return result;
    }

    public Set<OWLClass> getSubClasses(String classExpressionString, boolean direct) throws ParserException {
        if (classExpressionString.trim().length() == 0) {
            return Collections.emptySet();
        }
        OWLClassExpression classExpression = this.parser.parseClassExpression(classExpressionString);
        NodeSet<OWLClass> subClasses = this.reasoner.getSubClasses(classExpression, direct);
        return subClasses.getFlattened();
    }

    public Set<OWLNamedIndividual> getInstances(String classExpressionString, boolean direct) throws ParserException {
        if (classExpressionString.trim().length() == 0) {
            return Collections.emptySet();
        }
        OWLClassExpression classExpression = this.parser.parseClassExpression(classExpressionString);
        NodeSet<OWLNamedIndividual> individuals = this.reasoner.getInstances(classExpression, direct);
        return individuals.getFlattened();
    }
}

