/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples.dlquery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.coode.owlapi.examples.dlquery.DLQueryPrinter;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class DLQueryExample {
    private static final IRI ONTOLOGY_IRI = IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl");

    public static void main(String[] args) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            OWLOntology ontology = manager.loadOntologyFromOntologyDocument(ONTOLOGY_IRI);
            System.out.println("Loaded ontology: " + ontology.getOntologyID());
            OWLReasoner reasoner = DLQueryExample.createReasoner(ontology);
            SimpleShortFormProvider shortFormProvider = new SimpleShortFormProvider();
            DLQueryPrinter dlQueryPrinter = new DLQueryPrinter(reasoner, shortFormProvider);
            DLQueryExample.doQueryLoop(dlQueryPrinter);
        }
        catch (OWLOntologyCreationException e) {
            System.out.println("Could not load ontology: " + e.getMessage());
        }
        catch (IOException ioEx) {
            System.out.println(ioEx.getMessage());
        }
    }

    private static void doQueryLoop(DLQueryPrinter dlQueryPrinter) throws IOException {
        while (true) {
            System.out.println("Please type a class expression in Manchester Syntax and press Enter (or press x to exit):");
            System.out.println("");
            String classExpression = DLQueryExample.readInput();
            if (classExpression.equalsIgnoreCase("x")) break;
            dlQueryPrinter.askQuery(classExpression.trim());
            System.out.println();
            System.out.println();
        }
    }

    private static String readInput() throws IOException {
        InputStream is = System.in;
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        BufferedReader br = new BufferedReader(reader);
        return br.readLine();
    }

    private static OWLReasoner createReasoner(OWLOntology rootOntology) {
        OWLReasonerFactory reasonerFactory = null;
        return reasonerFactory.createReasoner(rootOntology);
    }
}

