/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.examples.dlquery;

import java.util.Set;
import org.coode.owlapi.examples.dlquery.DLQueryEngine;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.ShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLQueryPrinter {
    private OWLReasoner reasoner;
    private DLQueryEngine dlQueryEngine;
    private ShortFormProvider shortFormProvider;

    public DLQueryPrinter(OWLReasoner reasoner, ShortFormProvider shortFormProvider) {
        this.reasoner = reasoner;
        this.shortFormProvider = shortFormProvider;
        this.dlQueryEngine = new DLQueryEngine(reasoner, shortFormProvider);
    }

    public void askQuery(String classExpression) {
        if (classExpression.length() == 0) {
            System.out.println("No class expression specified");
        } else {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("\n--------------------------------------------------------------------------------\n");
                sb.append("QUERY:   ");
                sb.append(classExpression);
                sb.append("\n");
                sb.append("--------------------------------------------------------------------------------\n\n");
                Set<OWLClass> superClasses = this.dlQueryEngine.getSuperClasses(classExpression, true);
                this.printEntities("SuperClasses", superClasses, sb);
                Set<OWLClass> equivalentClasses = this.dlQueryEngine.getEquivalentClasses(classExpression);
                this.printEntities("EquivalentClasses", equivalentClasses, sb);
                Set<OWLClass> subClasses = this.dlQueryEngine.getSubClasses(classExpression, true);
                this.printEntities("SubClasses", subClasses, sb);
                Set<OWLNamedIndividual> individuals = this.dlQueryEngine.getInstances(classExpression, true);
                this.printEntities("Instances", individuals, sb);
                System.out.println(sb.toString());
            }
            catch (ParserException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void printEntities(String name, Set<? extends OWLEntity> entities, StringBuilder sb) {
        sb.append(name);
        int length = 50 - name.length();
        for (int i = 0; i < length; ++i) {
            sb.append(".");
        }
        sb.append("\n\n");
        if (!entities.isEmpty()) {
            for (OWLEntity oWLEntity : entities) {
                sb.append("\t");
                sb.append(this.shortFormProvider.getShortForm(oWLEntity));
                sb.append("\n");
            }
        } else {
            sb.append("\t[NONE]\n");
        }
        sb.append("\n");
    }
}

