/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.parser;

import java.util.HashMap;
import java.util.Map;
import org.coode.owlapi.obo.parser.OBOPrefix;

public class IDSpaceManager {
    private Map<String, String> idPrefix2IRIPrefixMap = new HashMap<String, String>();

    public IDSpaceManager() {
    }

    public IDSpaceManager(IDSpaceManager idSpaceManager) {
        if (idSpaceManager == null) {
            throw new NullPointerException("idSpaceManager must not be null");
        }
        this.idPrefix2IRIPrefixMap.putAll(idSpaceManager.idPrefix2IRIPrefixMap);
    }

    public String getDefaultIRIPrefix() {
        return OBOPrefix.OBO.getPrefix();
    }

    public String getIRIPrefix(String idPrefix) {
        String iriPrefix = this.idPrefix2IRIPrefixMap.get(idPrefix);
        if (iriPrefix != null) {
            return iriPrefix;
        }
        return this.getDefaultIRIPrefix();
    }

    public void setIRIPrefix(String idPrefix, String iriPrefix) {
        if (idPrefix == null) {
            throw new NullPointerException("idPrefix must not be null");
        }
        if (iriPrefix == null) {
            throw new NullPointerException("iriPrefix must not be null");
        }
        this.idPrefix2IRIPrefixMap.put(idPrefix, iriPrefix);
    }
}

