/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxmlparser;

import java.util.HashSet;
import java.util.Set;
import org.coode.owlapi.owlxmlparser.AbstractIRIElementHandler;
import org.coode.owlapi.owlxmlparser.AbstractOWLElementHandler;
import org.coode.owlapi.owlxmlparser.OWLAnnotationPropertyElementHandler;
import org.coode.owlapi.owlxmlparser.OWLAnonymousIndividualElementHandler;
import org.coode.owlapi.owlxmlparser.OWLLiteralElementHandler;
import org.coode.owlapi.owlxmlparser.OWLXMLParserException;
import org.coode.owlapi.owlxmlparser.OWLXMLParserHandler;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLAnnotationElementHandler
extends AbstractOWLElementHandler<OWLAnnotation> {
    private Set<OWLAnnotation> annotations;
    private OWLAnnotationProperty property;
    private OWLAnnotationValue object;

    public OWLAnnotationElementHandler(OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    public void startElement(String name) throws OWLXMLParserException {
        super.startElement(name);
    }

    @Override
    public void endElement() throws OWLParserException, UnloadableImportException {
        this.getParentHandler().handleChild(this);
    }

    @Override
    public void attribute(String localName, String value) throws OWLParserException {
        super.attribute(localName, value);
        if (localName.equals(OWLXMLVocabulary.ANNOTATION_URI.getShortName())) {
            IRI iri = this.getIRI(value);
            this.property = this.getOWLDataFactory().getOWLAnnotationProperty(iri);
        }
    }

    @Override
    public void handleChild(OWLAnnotationElementHandler handler) throws OWLXMLParserException {
        if (this.annotations == null) {
            this.annotations = new HashSet<OWLAnnotation>();
        }
        this.annotations.add(handler.getOWLObject());
    }

    @Override
    public void handleChild(OWLAnonymousIndividualElementHandler handler) throws OWLXMLParserException {
        this.object = handler.getOWLObject();
    }

    @Override
    public void handleChild(OWLLiteralElementHandler handler) throws OWLXMLParserException {
        this.object = handler.getOWLObject();
    }

    @Override
    public void handleChild(OWLAnnotationPropertyElementHandler handler) throws OWLXMLParserException {
        this.property = handler.getOWLObject();
    }

    @Override
    public void handleChild(AbstractIRIElementHandler handler) throws OWLXMLParserException {
        this.object = (OWLAnnotationValue)handler.getOWLObject();
    }

    @Override
    public OWLAnnotation getOWLObject() {
        if (this.annotations == null) {
            return this.getOWLDataFactory().getOWLAnnotation(this.property, this.object);
        }
        return this.getOWLDataFactory().getOWLAnnotation(this.property, this.object, this.annotations);
    }

    @Override
    public boolean isTextContentPossible() {
        return false;
    }
}

