/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.Collections;
import java.util.Set;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.OptimisedListTranslator;
import org.coode.owlapi.rdfxml.parser.SWRLAtomListItemTranslator;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.vocab.SWRLVocabulary;

public class SWRLRuleTranslator {
    private OWLRDFConsumer consumer;
    private OptimisedListTranslator<SWRLAtom> listTranslator;

    public SWRLRuleTranslator(OWLRDFConsumer consumer) {
        this.consumer = consumer;
        this.listTranslator = new OptimisedListTranslator<SWRLAtom>(consumer, new SWRLAtomListItemTranslator(consumer));
    }

    public void translateRule(IRI mainNode) {
        Set<Object> consequent = Collections.emptySet();
        IRI ruleHeadIRI = this.consumer.getResourceObject(mainNode, SWRLVocabulary.HEAD.getIRI(), true);
        if (ruleHeadIRI != null) {
            consequent = this.listTranslator.translateToSet(ruleHeadIRI);
        }
        Set<Object> antecedent = Collections.emptySet();
        IRI ruleBodyIRI = this.consumer.getResourceObject(mainNode, SWRLVocabulary.BODY.getIRI(), true);
        if (ruleBodyIRI != null) {
            antecedent = this.listTranslator.translateToSet(ruleBodyIRI);
        }
        SWRLRule rule = null;
        rule = !this.consumer.isAnonymousNode(mainNode) ? this.consumer.getDataFactory().getSWRLRule(antecedent, consequent) : this.consumer.getDataFactory().getSWRLRule(antecedent, consequent);
        this.consumer.addAxiom(rule);
    }
}

