/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPPropertyRangeHandler
extends TriplePredicateHandler {
    public TPPropertyRangeHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_RANGE.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        this.inferTypes(subject, object);
        return false;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.isStrict()) {
            if (this.isObjectPropertyStrict(subject) && this.isClassExpressionStrict(object)) {
                this.translateAsObjectPropertyRange(subject, predicate, object);
            } else if (this.isDataPropertyStrict(subject) && this.isDataRangeStrict(object)) {
                this.translateAsDataPropertyRange(subject, predicate, object);
            } else if (this.getConsumer().isAnnotationProperty(subject) && !this.getConsumer().isAnonymousNode(object)) {
                this.translateAsAnnotationPropertyRange(subject, predicate, object);
            }
        } else if (this.isAnnotationPropertyOnly(subject) && !this.isAnonymous(object)) {
            this.translateAsAnnotationPropertyRange(subject, predicate, object);
        } else if (this.isClassExpressionLax(object)) {
            this.translateAsObjectPropertyRange(subject, predicate, object);
        } else if (this.isDataRangeLax(object)) {
            this.translateAsDataPropertyRange(subject, predicate, object);
        } else if (this.isObjectPropertyLax(subject)) {
            this.translateAsObjectPropertyRange(subject, predicate, object);
        } else if (this.isDataPropertyLax(subject)) {
            this.translateAsDataPropertyRange(subject, predicate, object);
        } else {
            this.translateAsAnnotationPropertyRange(subject, predicate, object);
        }
    }

    private void translateAsAnnotationPropertyRange(IRI subject, IRI predicate, IRI object) {
        OWLAnnotationProperty prop = this.getDataFactory().getOWLAnnotationProperty(subject);
        this.addAxiom(this.getDataFactory().getOWLAnnotationPropertyRangeAxiom(prop, object, this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }

    private void translateAsDataPropertyRange(IRI subject, IRI predicate, IRI object) {
        OWLDataPropertyExpression property = this.translateDataProperty(subject);
        OWLDataRange dataRange = this.translateDataRange(object);
        this.addAxiom(this.getDataFactory().getOWLDataPropertyRangeAxiom(property, dataRange, this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }

    private void translateAsObjectPropertyRange(IRI subject, IRI predicate, IRI object) {
        OWLObjectPropertyExpression property = this.translateObjectProperty(subject);
        OWLClassExpression range = this.translateClassExpression(object);
        this.addAxiom(this.getDataFactory().getOWLObjectPropertyRangeAxiom(property, range, this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }
}

