/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxiomType<C extends OWLAxiom>
implements Serializable {
    private static final long serialVersionUID = -8371103622896763859L;
    private final String name;
    private final boolean owl2Axiom;
    private final boolean nonSyntacticOWL2Axiom;
    private final boolean isLogical;
    public final int index;
    public static final Set<AxiomType<?>> AXIOM_TYPES = new HashSet();
    private static final Map<String, AxiomType<?>> NAME_TYPE_MAP = new HashMap();
    private static final AtomicInteger counter = new AtomicInteger();
    public static final AxiomType<OWLDeclarationAxiom> DECLARATION = AxiomType.getInstance("Declaration", true, true, false);
    public static final AxiomType<OWLEquivalentClassesAxiom> EQUIVALENT_CLASSES = AxiomType.getInstance("EquivalentClasses", false, false, true);
    public static final AxiomType<OWLSubClassOfAxiom> SUBCLASS_OF = AxiomType.getInstance("SubClassOf", false, false, true);
    public static final AxiomType<OWLDisjointClassesAxiom> DISJOINT_CLASSES = AxiomType.getInstance("DisjointClasses", false, false, true);
    public static final AxiomType<OWLDisjointUnionAxiom> DISJOINT_UNION = AxiomType.getInstance("DisjointUnion", true, false, true);
    public static final AxiomType<OWLClassAssertionAxiom> CLASS_ASSERTION = AxiomType.getInstance("ClassAssertion", false, false, true);
    public static final AxiomType<OWLSameIndividualAxiom> SAME_INDIVIDUAL = AxiomType.getInstance("SameIndividual", false, false, true);
    public static final AxiomType<OWLDifferentIndividualsAxiom> DIFFERENT_INDIVIDUALS = AxiomType.getInstance("DifferentIndividuals", false, false, true);
    public static final AxiomType<OWLObjectPropertyAssertionAxiom> OBJECT_PROPERTY_ASSERTION = AxiomType.getInstance("ObjectPropertyAssertion", false, false, true);
    public static final AxiomType<OWLNegativeObjectPropertyAssertionAxiom> NEGATIVE_OBJECT_PROPERTY_ASSERTION = AxiomType.getInstance("NegativeObjectPropertyAssertion", true, false, true);
    public static final AxiomType<OWLDataPropertyAssertionAxiom> DATA_PROPERTY_ASSERTION = AxiomType.getInstance("DataPropertyAssertion", false, false, true);
    public static final AxiomType<OWLNegativeDataPropertyAssertionAxiom> NEGATIVE_DATA_PROPERTY_ASSERTION = AxiomType.getInstance("NegativeDataPropertyAssertion", true, false, true);
    public static final AxiomType<OWLEquivalentObjectPropertiesAxiom> EQUIVALENT_OBJECT_PROPERTIES = AxiomType.getInstance("EquivalentObjectProperties", false, false, true);
    public static final AxiomType<OWLSubObjectPropertyOfAxiom> SUB_OBJECT_PROPERTY = AxiomType.getInstance("SubObjectPropertyOf", false, false, true);
    public static final AxiomType<OWLInverseObjectPropertiesAxiom> INVERSE_OBJECT_PROPERTIES = AxiomType.getInstance("InverseObjectProperties", false, false, true);
    public static final AxiomType<OWLFunctionalObjectPropertyAxiom> FUNCTIONAL_OBJECT_PROPERTY = AxiomType.getInstance("FunctionalObjectProperty", false, false, true);
    public static final AxiomType<OWLInverseFunctionalObjectPropertyAxiom> INVERSE_FUNCTIONAL_OBJECT_PROPERTY = AxiomType.getInstance("InverseFunctionalObjectProperty", false, false, true);
    public static final AxiomType<OWLSymmetricObjectPropertyAxiom> SYMMETRIC_OBJECT_PROPERTY = AxiomType.getInstance("SymmetricObjectProperty", false, false, true);
    public static final AxiomType<OWLAsymmetricObjectPropertyAxiom> ASYMMETRIC_OBJECT_PROPERTY = AxiomType.getInstance("AsymmetricObjectProperty", true, true, true);
    public static final AxiomType<OWLTransitiveObjectPropertyAxiom> TRANSITIVE_OBJECT_PROPERTY = AxiomType.getInstance("TransitiveObjectProperty", false, false, true);
    public static final AxiomType<OWLReflexiveObjectPropertyAxiom> REFLEXIVE_OBJECT_PROPERTY = AxiomType.getInstance("ReflexiveObjectProperty", true, true, true);
    public static final AxiomType<OWLIrreflexiveObjectPropertyAxiom> IRREFLEXIVE_OBJECT_PROPERTY = AxiomType.getInstance("IrrefexiveObjectProperty", true, true, true);
    public static final AxiomType<OWLObjectPropertyDomainAxiom> OBJECT_PROPERTY_DOMAIN = AxiomType.getInstance("ObjectPropertyDomain", false, false, true);
    public static final AxiomType<OWLObjectPropertyRangeAxiom> OBJECT_PROPERTY_RANGE = AxiomType.getInstance("ObjectPropertyRange", false, false, true);
    public static final AxiomType<OWLDisjointObjectPropertiesAxiom> DISJOINT_OBJECT_PROPERTIES = AxiomType.getInstance("DisjointObjectProperties", true, true, true);
    public static final AxiomType<OWLSubPropertyChainOfAxiom> SUB_PROPERTY_CHAIN_OF = AxiomType.getInstance("SubPropertyChainOf", true, true, true);
    public static final AxiomType<OWLEquivalentDataPropertiesAxiom> EQUIVALENT_DATA_PROPERTIES = AxiomType.getInstance("EquivalentDataProperties", false, false, true);
    public static final AxiomType<OWLSubDataPropertyOfAxiom> SUB_DATA_PROPERTY = AxiomType.getInstance("SubDataPropertyOf", false, false, true);
    public static final AxiomType<OWLFunctionalDataPropertyAxiom> FUNCTIONAL_DATA_PROPERTY = AxiomType.getInstance("FunctionalDataProperty", false, false, true);
    public static final AxiomType<OWLDataPropertyDomainAxiom> DATA_PROPERTY_DOMAIN = AxiomType.getInstance("DataPropertyDomain", false, false, true);
    public static final AxiomType<OWLDataPropertyRangeAxiom> DATA_PROPERTY_RANGE = AxiomType.getInstance("DataPropertyRange", false, false, true);
    public static final AxiomType<OWLDisjointDataPropertiesAxiom> DISJOINT_DATA_PROPERTIES = AxiomType.getInstance("DisjointDataProperties", true, true, true);
    public static final AxiomType<OWLHasKeyAxiom> HAS_KEY = AxiomType.getInstance("HasKey", true, true, true);
    public static final AxiomType<SWRLRule> SWRL_RULE = AxiomType.getInstance("Rule", false, false, true);
    public static final AxiomType<OWLAnnotationAssertionAxiom> ANNOTATION_ASSERTION = AxiomType.getInstance("AnnotationAssertion", false, false, false);
    public static final AxiomType<OWLSubAnnotationPropertyOfAxiom> SUB_ANNOTATION_PROPERTY_OF = AxiomType.getInstance("SubAnnotationPropertyOf", true, true, false);
    public static final AxiomType<OWLAnnotationPropertyRangeAxiom> ANNOTATION_PROPERTY_RANGE = AxiomType.getInstance("AnnotationPropertyRangeOf", true, true, false);
    public static final AxiomType<OWLAnnotationPropertyDomainAxiom> ANNOTATION_PROPERTY_DOMAIN = AxiomType.getInstance("AnnotationPropertyDomain", true, true, false);
    public static final AxiomType<OWLDatatypeDefinitionAxiom> DATATYPE_DEFINITION = AxiomType.getInstance("DatatypeDefinition", true, true, true);
    public static final Set<AxiomType<?>> TBoxAxiomTypes;
    public static final Set<AxiomType<?>> ABoxAxiomTypes;
    public static final Set<AxiomType<?>> RBoxAxiomTypes;

    private AxiomType(int ind, String name, boolean owl2Axiom, boolean nonSyntacticOWL2Axiom, boolean isLogical) {
        this.name = name;
        this.owl2Axiom = owl2Axiom;
        this.nonSyntacticOWL2Axiom = nonSyntacticOWL2Axiom;
        this.isLogical = isLogical;
        this.index = ind;
    }

    private static <O extends OWLAxiom> AxiomType<O> getInstance(String name, boolean owl2Axiom, boolean nonSyntacticOWL2Axiom, boolean isLogical) {
        return new AxiomType(counter.getAndIncrement(), name, owl2Axiom, nonSyntacticOWL2Axiom, isLogical);
    }

    public String toString() {
        return this.name;
    }

    public boolean isOWL2Axiom() {
        return this.owl2Axiom;
    }

    public boolean isNonSyntacticOWL2Axiom() {
        return this.nonSyntacticOWL2Axiom;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLogical() {
        return this.isLogical;
    }

    public static Set<OWLAxiom> getAxiomsWithoutTypes(Set<OWLAxiom> sourceAxioms, AxiomType<?> ... axiomTypes) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        HashSet disallowed = new HashSet();
        for (AxiomType<?> t : axiomTypes) {
            disallowed.add(t);
        }
        for (OWLAxiom ax : sourceAxioms) {
            if (disallowed.contains(ax.getAxiomType())) continue;
            result.add(ax);
        }
        return result;
    }

    public static Set<OWLAxiom> getAxiomsOfTypes(Set<OWLAxiom> sourceAxioms, AxiomType<?> ... axiomTypes) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        HashSet allowed = new HashSet();
        for (AxiomType<?> t : axiomTypes) {
            allowed.add(t);
        }
        for (OWLAxiom ax : sourceAxioms) {
            if (!allowed.contains(ax.getAxiomType())) continue;
            result.add(ax);
        }
        return result;
    }

    public static AxiomType<?> getAxiomType(String name) {
        return NAME_TYPE_MAP.get(name);
    }

    public boolean isAxiomType(String _name) {
        return NAME_TYPE_MAP.containsKey(_name);
    }

    static {
        AXIOM_TYPES.add(SUBCLASS_OF);
        AXIOM_TYPES.add(EQUIVALENT_CLASSES);
        AXIOM_TYPES.add(DISJOINT_CLASSES);
        AXIOM_TYPES.add(CLASS_ASSERTION);
        AXIOM_TYPES.add(SAME_INDIVIDUAL);
        AXIOM_TYPES.add(DIFFERENT_INDIVIDUALS);
        AXIOM_TYPES.add(OBJECT_PROPERTY_ASSERTION);
        AXIOM_TYPES.add(NEGATIVE_OBJECT_PROPERTY_ASSERTION);
        AXIOM_TYPES.add(DATA_PROPERTY_ASSERTION);
        AXIOM_TYPES.add(NEGATIVE_DATA_PROPERTY_ASSERTION);
        AXIOM_TYPES.add(OBJECT_PROPERTY_DOMAIN);
        AXIOM_TYPES.add(OBJECT_PROPERTY_RANGE);
        AXIOM_TYPES.add(DISJOINT_OBJECT_PROPERTIES);
        AXIOM_TYPES.add(SUB_OBJECT_PROPERTY);
        AXIOM_TYPES.add(EQUIVALENT_OBJECT_PROPERTIES);
        AXIOM_TYPES.add(INVERSE_OBJECT_PROPERTIES);
        AXIOM_TYPES.add(SUB_PROPERTY_CHAIN_OF);
        AXIOM_TYPES.add(FUNCTIONAL_OBJECT_PROPERTY);
        AXIOM_TYPES.add(INVERSE_FUNCTIONAL_OBJECT_PROPERTY);
        AXIOM_TYPES.add(SYMMETRIC_OBJECT_PROPERTY);
        AXIOM_TYPES.add(ASYMMETRIC_OBJECT_PROPERTY);
        AXIOM_TYPES.add(TRANSITIVE_OBJECT_PROPERTY);
        AXIOM_TYPES.add(REFLEXIVE_OBJECT_PROPERTY);
        AXIOM_TYPES.add(IRREFLEXIVE_OBJECT_PROPERTY);
        AXIOM_TYPES.add(DATA_PROPERTY_DOMAIN);
        AXIOM_TYPES.add(DATA_PROPERTY_RANGE);
        AXIOM_TYPES.add(DISJOINT_DATA_PROPERTIES);
        AXIOM_TYPES.add(SUB_DATA_PROPERTY);
        AXIOM_TYPES.add(EQUIVALENT_DATA_PROPERTIES);
        AXIOM_TYPES.add(FUNCTIONAL_DATA_PROPERTY);
        AXIOM_TYPES.add(DATATYPE_DEFINITION);
        AXIOM_TYPES.add(DISJOINT_UNION);
        AXIOM_TYPES.add(DECLARATION);
        AXIOM_TYPES.add(SWRL_RULE);
        AXIOM_TYPES.add(ANNOTATION_ASSERTION);
        AXIOM_TYPES.add(SUB_ANNOTATION_PROPERTY_OF);
        AXIOM_TYPES.add(ANNOTATION_PROPERTY_DOMAIN);
        AXIOM_TYPES.add(ANNOTATION_PROPERTY_RANGE);
        AXIOM_TYPES.add(HAS_KEY);
        for (AxiomType<?> type : AXIOM_TYPES) {
            NAME_TYPE_MAP.put(type.name, type);
        }
        TBoxAxiomTypes = new HashSet<AxiomType>(Arrays.asList(SUBCLASS_OF, EQUIVALENT_CLASSES, DISJOINT_CLASSES, OBJECT_PROPERTY_DOMAIN, OBJECT_PROPERTY_RANGE, INVERSE_OBJECT_PROPERTIES, FUNCTIONAL_OBJECT_PROPERTY, INVERSE_FUNCTIONAL_OBJECT_PROPERTY, SYMMETRIC_OBJECT_PROPERTY, ASYMMETRIC_OBJECT_PROPERTY, TRANSITIVE_OBJECT_PROPERTY, REFLEXIVE_OBJECT_PROPERTY, IRREFLEXIVE_OBJECT_PROPERTY, DATA_PROPERTY_DOMAIN, DATA_PROPERTY_RANGE, FUNCTIONAL_DATA_PROPERTY, DATATYPE_DEFINITION, DISJOINT_UNION, HAS_KEY));
        ABoxAxiomTypes = new HashSet<AxiomType>(Arrays.asList(CLASS_ASSERTION, SAME_INDIVIDUAL, DIFFERENT_INDIVIDUALS, OBJECT_PROPERTY_ASSERTION, NEGATIVE_OBJECT_PROPERTY_ASSERTION, DATA_PROPERTY_ASSERTION, NEGATIVE_DATA_PROPERTY_ASSERTION, DATATYPE_DEFINITION));
        RBoxAxiomTypes = new HashSet<AxiomType>(Arrays.asList(TRANSITIVE_OBJECT_PROPERTY, DISJOINT_DATA_PROPERTIES, SUB_DATA_PROPERTY, EQUIVALENT_DATA_PROPERTIES, DISJOINT_OBJECT_PROPERTIES, SUB_OBJECT_PROPERTY, EQUIVALENT_OBJECT_PROPERTIES, SUB_PROPERTY_CHAIN_OF));
    }
}

