/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OWLOntologyAlreadyExistsException
extends OWLOntologyCreationException {
    private static final long serialVersionUID = 8631951244515672460L;
    private static final String ONTOLOGY_ALREADY_EXISTS = "Ontology already exists. ";
    private final OWLOntologyID ontologyID;
    private final IRI documentIRI;

    public OWLOntologyAlreadyExistsException(OWLOntologyID id) {
        super(ONTOLOGY_ALREADY_EXISTS + id);
        this.ontologyID = id;
        this.documentIRI = null;
    }

    public OWLOntologyAlreadyExistsException(OWLOntologyID ontologyID, IRI documentIRI) {
        super(ONTOLOGY_ALREADY_EXISTS + ontologyID + " (New ontology loaded from " + documentIRI.toQuotedString() + ")");
        this.ontologyID = ontologyID;
        this.documentIRI = documentIRI;
    }

    public OWLOntologyAlreadyExistsException(OWLOntologyID id, Throwable t) {
        super(ONTOLOGY_ALREADY_EXISTS + id, t);
        this.ontologyID = id;
        this.documentIRI = null;
    }

    public OWLOntologyAlreadyExistsException(OWLOntologyID ontologyID, IRI documentIRI, Throwable t) {
        super(ONTOLOGY_ALREADY_EXISTS + ontologyID + " (New ontology loaded from " + documentIRI.toQuotedString() + ")", t);
        this.ontologyID = ontologyID;
        this.documentIRI = documentIRI;
    }

    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    public IRI getDocumentIRI() {
        return this.documentIRI;
    }
}

