/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoIRIMapper
extends DefaultHandler
implements OWLOntologyIRIMapper {
    private final Set<String> fileExtensions;
    private final transient File directory;
    private boolean mapped;
    private final boolean recursive;
    private final Map<String, OntologyRootElementHandler> handlerMap;
    private transient File currentFile;
    private final Map<IRI, IRI> ontologyIRI2PhysicalURIMap;
    private Map<String, IRI> oboFileMap;
    private transient SAXParserFactory parserFactory;

    public AutoIRIMapper(File rootDirectory, boolean recursive) {
        this.directory = rootDirectory;
        this.recursive = recursive;
        this.ontologyIRI2PhysicalURIMap = new HashMap<IRI, IRI>();
        this.oboFileMap = new HashMap<String, IRI>();
        this.fileExtensions = new HashSet<String>();
        this.fileExtensions.add("owl");
        this.fileExtensions.add("xml");
        this.fileExtensions.add("rdf");
        this.fileExtensions.add("omn");
        this.mapped = false;
        this.handlerMap = new HashMap<String, OntologyRootElementHandler>();
        this.handlerMap.put((Object)((Object)Namespaces.RDF) + "RDF", new RDFXMLOntologyRootElementHandler());
        this.handlerMap.put(OWLXMLVocabulary.ONTOLOGY.toString(), new OWLXMLOntologyRootElementHandler());
        this.parserFactory = SAXParserFactory.newInstance();
        this.parserFactory.setNamespaceAware(true);
    }

    public Set<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(Set<String> extensions) {
        this.fileExtensions.clear();
        this.fileExtensions.addAll(extensions);
    }

    public Set<IRI> getOntologyIRIs() {
        if (!this.mapped) {
            this.mapFiles();
        }
        return new HashSet<IRI>(this.ontologyIRI2PhysicalURIMap.keySet());
    }

    public void update() {
        this.mapFiles();
    }

    @Override
    public IRI getDocumentIRI(IRI ontologyIRI) {
        int lastSepIndex;
        String name;
        IRI documentIRI;
        String path;
        if (!this.mapped) {
            this.mapFiles();
        }
        if (ontologyIRI.toString().endsWith(".obo") && (path = ontologyIRI.toURI().getPath()) != null && (documentIRI = this.oboFileMap.get(name = path.substring((lastSepIndex = path.lastIndexOf(47)) + 1, path.length()))) != null) {
            return documentIRI;
        }
        return this.ontologyIRI2PhysicalURIMap.get(ontologyIRI);
    }

    private void mapFiles() {
        this.mapped = true;
        this.ontologyIRI2PhysicalURIMap.clear();
        this.processFile(this.directory);
    }

    private void processFile(File f) {
        if (f.isHidden()) {
            return;
        }
        File[] files = f.listFiles();
        if (files != null) {
            block0: for (File file : files) {
                if (file.isDirectory() && this.recursive) {
                    this.processFile(file);
                    continue;
                }
                if (file.getName().endsWith(".obo")) {
                    this.oboFileMap.put(file.getName(), IRI.create(file));
                    continue;
                }
                if (file.getName().endsWith(".omn")) {
                    this.parseManchesterSyntaxFile(file);
                    continue;
                }
                for (String ext : this.fileExtensions) {
                    if (!file.getName().endsWith(ext)) continue;
                    this.parseFile(file);
                    continue block0;
                }
            }
        }
    }

    private void parseFile(File file) {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                this.currentFile = file;
                SAXParser parser = this.parserFactory.newSAXParser();
                parser.parse((InputStream)is, (DefaultHandler)this);
            }
            catch (ParserConfigurationException e) {
                throw new OWLRuntimeException(e);
            }
            catch (SAXException e) {
            }
            catch (IOException iOException) {
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void parseManchesterSyntaxFile(File file) {
        block13: {
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = br.readLine();
            IRI ontologyIRI = null;
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, " \r\n", false);
                line = br.readLine();
                while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken();
                    if (!tok.startsWith("<") || !tok.endsWith(">")) continue;
                    ontologyIRI = IRI.create(tok.substring(1, tok.length() - 1));
                    this.ontologyIRI2PhysicalURIMap.put(ontologyIRI, IRI.create(file));
                    break;
                }
                if (ontologyIRI == null) continue;
                break;
            }
            Object var8_8 = null;
            try {
                if (br != null) {
                    br.close();
                }
                break block13;
            }
            catch (IOException e2) {}
            break block13;
            {
                catch (IOException iOException) {
                    Object var8_9 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block13;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        OntologyRootElementHandler handler = this.handlerMap.get(uri + localName);
        if (handler != null) {
            IRI ontologyIRI = handler.handle(attributes);
            if (ontologyIRI != null) {
                this.ontologyIRI2PhysicalURIMap.put(ontologyIRI, IRI.create(this.currentFile));
            }
            throw new SAXException();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoURIMapper: (");
        sb.append(this.ontologyIRI2PhysicalURIMap.size());
        sb.append(" ontologies)\n");
        for (IRI iri : this.ontologyIRI2PhysicalURIMap.keySet()) {
            sb.append("    ");
            sb.append(iri.toQuotedString());
            sb.append(" -> ");
            sb.append(this.ontologyIRI2PhysicalURIMap.get(iri));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static class OWLXMLOntologyRootElementHandler
    implements OntologyRootElementHandler,
    Serializable {
        private static final long serialVersionUID = -4399198105058694367L;

        public IRI handle(Attributes attributes) {
            String ontURI = attributes.getValue(Namespaces.OWL.toString(), "ontologyIRI");
            if (ontURI == null) {
                ontURI = attributes.getValue(Namespaces.OWL.toString(), "ontologyIRI");
            }
            if (ontURI == null) {
                return null;
            }
            return IRI.create(ontURI);
        }
    }

    private static class RDFXMLOntologyRootElementHandler
    implements OntologyRootElementHandler,
    Serializable {
        private static final long serialVersionUID = 4935017093359476433L;

        public IRI handle(Attributes attributes) {
            String baseValue = attributes.getValue(Namespaces.XML.toString(), "base");
            if (baseValue == null) {
                return null;
            }
            return IRI.create(baseValue);
        }
    }

    private static interface OntologyRootElementHandler {
        public IRI handle(Attributes var1);
    }
}

