/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionFactory {
    private static final AtomicInteger expectedThreads = new AtomicInteger(16);

    public static void setExpectedThreads(int value) {
        expectedThreads.set(value);
    }

    public static <T> Set<T> createSet() {
        return new HashSet();
    }

    public static <T> List<T> createList() {
        return new ArrayList();
    }

    public static <T> Set<T> createSet(Collection<T> c) {
        return new HashSet<T>(c);
    }

    public static <T> Set<T> createSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    public static <K, V> Map<K, V> createMap() {
        return new HashMap();
    }

    public static <T> Set<T> createSet(T ... elements) {
        Set<T> result = CollectionFactory.createSet();
        for (T t : elements) {
            result.add(t);
        }
        return result;
    }

    public static <T> Set<T> createSyncSet() {
        return new SyncSet();
    }

    public static <K, V> ConcurrentHashMap<K, V> createSyncMap() {
        return new ConcurrentHashMap(16, 0.75f, expectedThreads.get());
    }

    public static <T> Set<T> getCopyOnRequestSet(Collection<T> source) {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(source);
    }

    public static <T> Set<T> getCopyOnRequestSetFromMutableCollection(Collection<T> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptySet();
        }
        return new ConditionalCopySet<T>(source, true);
    }

    public static <T> Set<T> getCopyOnRequestSetFromImmutableCollection(Collection<T> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptySet();
        }
        return new ConditionalCopySet<T>(source, false);
    }

    public static <T> Set<T> getThreadSafeCopyOnRequestSet(Set<T> source) {
        return new ThreadSafeConditionalCopySet<T>(source);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadSafeConditionalCopySet<T>
    implements Set<T> {
        private volatile boolean copyDone = false;
        private Collection<T> delegate;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final Lock readLock = this.lock.readLock();
        private final Lock writeLock = this.lock.writeLock();
        private static final int maxContains = 10;
        private volatile int containsCounter = 0;

        public ThreadSafeConditionalCopySet(Collection<T> source) {
            this.delegate = new ArrayList<T>(source);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object obj) {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            try {
                                this.readLock.lock();
                                if (obj != null) break block6;
                                boolean bl = false;
                                Object var4_7 = null;
                                this.readLock.unlock();
                                return bl;
                            }
                            catch (Throwable throwable) {
                                Object var4_12 = null;
                                this.readLock.unlock();
                                throw throwable;
                            }
                        }
                        if (this != obj) break block7;
                        boolean bl = true;
                        Object var4_8 = null;
                        this.readLock.unlock();
                        return bl;
                    }
                    if (!(obj instanceof ConditionalCopySet)) break block8;
                    boolean bl = ((Object)this.delegate).equals(((ConditionalCopySet)obj).delegate);
                    Object var4_9 = null;
                    this.readLock.unlock();
                    return bl;
                }
                if (!(obj instanceof Set)) break block9;
                boolean bl = ((Object)this.delegate).equals(obj);
                Object var4_10 = null;
                this.readLock.unlock();
                return bl;
            }
            boolean bl = false;
            Object var4_11 = null;
            this.readLock.unlock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            try {
                this.readLock.lock();
                int n = ((Object)this.delegate).hashCode();
                Object var3_2 = null;
                this.readLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(T arg0) {
            try {
                this.writeLock.lock();
                if (!this.copyDone) {
                    this.copyDone = true;
                    this.delegate = new SyncSet<T>(this.delegate);
                }
                boolean bl = this.delegate.add(arg0);
                Object var4_3 = null;
                this.writeLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends T> arg0) {
            try {
                this.writeLock.lock();
                if (!this.copyDone) {
                    this.copyDone = true;
                    this.delegate = new SyncSet<T>(this.delegate);
                }
                boolean bl = this.delegate.addAll(arg0);
                Object var4_3 = null;
                this.writeLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            try {
                this.writeLock.lock();
                if (!this.copyDone) {
                    this.copyDone = true;
                    this.delegate = new SyncSet();
                }
                this.delegate.clear();
                Object var2_1 = null;
                this.writeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object arg0) {
            if (!this.copyDone) {
                ++this.containsCounter;
                if (this.containsCounter >= 10 && !this.copyDone) {
                    try {
                        this.writeLock.lock();
                        if (!this.copyDone && !(this.delegate instanceof Set)) {
                            this.copyDone = true;
                            this.delegate = new SyncSet<T>(this.delegate);
                        }
                        boolean bl = this.delegate.contains(arg0);
                        Object var4_4 = null;
                        this.writeLock.unlock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.writeLock.unlock();
                        throw throwable;
                    }
                }
            }
            try {
                this.readLock.lock();
                boolean bl = this.delegate.contains(arg0);
                Object var6_7 = null;
                this.readLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> arg0) {
            if (!this.copyDone) {
                ++this.containsCounter;
                if (this.containsCounter >= 10 && !this.copyDone) {
                    try {
                        this.writeLock.lock();
                        if (!this.copyDone && !(this.delegate instanceof Set)) {
                            this.copyDone = true;
                            this.delegate = new SyncSet<T>(this.delegate);
                        }
                        boolean bl = this.delegate.containsAll(arg0);
                        Object var4_4 = null;
                        this.writeLock.unlock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.writeLock.unlock();
                        throw throwable;
                    }
                }
            }
            try {
                this.readLock.lock();
                boolean bl = this.delegate.containsAll(arg0);
                Object var6_7 = null;
                this.readLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            try {
                this.readLock.lock();
                boolean bl = this.delegate.isEmpty();
                Object var3_2 = null;
                this.readLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<T> iterator() {
            try {
                this.readLock.lock();
                Iterator<T> iterator = this.delegate.iterator();
                Object var3_2 = null;
                this.readLock.unlock();
                return iterator;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object arg0) {
            try {
                this.writeLock.lock();
                if (!this.copyDone) {
                    this.copyDone = true;
                    this.delegate = new SyncSet<T>(this.delegate);
                }
                boolean bl = this.delegate.remove(arg0);
                Object var4_3 = null;
                this.writeLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> arg0) {
            try {
                this.writeLock.lock();
                if (!this.copyDone) {
                    this.copyDone = true;
                    this.delegate = new SyncSet<T>(this.delegate);
                }
                boolean bl = this.delegate.removeAll(arg0);
                Object var4_3 = null;
                this.writeLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> arg0) {
            try {
                this.writeLock.lock();
                if (!this.copyDone) {
                    this.copyDone = true;
                    this.delegate = new SyncSet<T>(this.delegate);
                }
                boolean bl = this.delegate.retainAll(arg0);
                Object var4_3 = null;
                this.writeLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            try {
                this.readLock.lock();
                int n = this.delegate.size();
                Object var3_2 = null;
                this.readLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            try {
                this.readLock.lock();
                Object[] objectArray = this.delegate.toArray();
                Object var3_2 = null;
                this.readLock.unlock();
                return objectArray;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <Type> Type[] toArray(Type[] arg0) {
            try {
                this.readLock.lock();
                Type[] TypeArray = this.delegate.toArray(arg0);
                Object var4_3 = null;
                this.readLock.unlock();
                return TypeArray;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConditionalCopySet<T>
    implements Set<T> {
        private boolean copyDone = false;
        private Collection<T> delegate;
        private static final int maxContains = 10;
        private int containsCounter = 0;

        public ConditionalCopySet(Collection<T> source, boolean listCopy) {
            this.delegate = listCopy ? new ArrayList<T>(source) : source;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConditionalCopySet) {
                return this.delegate.containsAll(((ConditionalCopySet)obj).delegate) && ((ConditionalCopySet)obj).delegate.containsAll(this.delegate);
            }
            if (obj instanceof Collection) {
                return this.delegate.containsAll((Collection)obj) && ((Collection)obj).containsAll(this.delegate);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean add(T arg0) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new HashSet<T>(this.delegate);
            }
            return this.delegate.add(arg0);
        }

        @Override
        public boolean addAll(Collection<? extends T> arg0) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new HashSet<T>(this.delegate);
            }
            return this.delegate.addAll(arg0);
        }

        @Override
        public void clear() {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new HashSet<T>();
            }
            this.delegate.clear();
        }

        @Override
        public boolean contains(Object arg0) {
            ++this.containsCounter;
            if (this.containsCounter >= 10 && !this.copyDone && !(this.delegate instanceof Set)) {
                this.copyDone = true;
                this.delegate = new HashSet<T>(this.delegate);
            }
            return this.delegate.contains(arg0);
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            ++this.containsCounter;
            if (this.containsCounter >= 10 && !this.copyDone && !(this.delegate instanceof Set)) {
                this.copyDone = true;
                this.delegate = new HashSet<T>(this.delegate);
            }
            return this.delegate.containsAll(arg0);
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public boolean remove(Object arg0) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new HashSet<T>(this.delegate);
            }
            return this.delegate.remove(arg0);
        }

        @Override
        public boolean removeAll(Collection<?> arg0) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new HashSet<T>(this.delegate);
            }
            return this.delegate.removeAll(arg0);
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new HashSet<T>(this.delegate);
            }
            return this.delegate.retainAll(arg0);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <Type> Type[] toArray(Type[] arg0) {
            return this.delegate.toArray(arg0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SyncSet<T>
    implements Set<T> {
        private final ConcurrentHashMap<T, Set<T>> backingMap;

        public SyncSet(ConcurrentHashMap<T, Set<T>> map) {
            this.backingMap = map;
        }

        public SyncSet() {
            this(new ConcurrentHashMap());
        }

        public SyncSet(Collection<T> delegate) {
            this();
            for (T d : delegate) {
                this.add(d);
            }
        }

        @Override
        public boolean add(T e) {
            return this.backingMap.put(e, this) == null;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean toReturn = false;
            for (T o : c) {
                toReturn = toReturn || this.add(o);
            }
            return toReturn;
        }

        @Override
        public void clear() {
            this.backingMap.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.backingMap.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            boolean toReturn = true;
            for (Object o : c) {
                if (toReturn = toReturn && this.contains(o)) continue;
                return toReturn;
            }
            return toReturn;
        }

        @Override
        public boolean isEmpty() {
            return this.backingMap.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.backingMap.keySet().iterator();
        }

        @Override
        public int size() {
            return this.backingMap.size();
        }

        @Override
        public boolean remove(Object o) {
            return this.backingMap.remove(o) != null;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean toReturn = false;
            for (Object o : c) {
                toReturn = toReturn || this.remove(o);
            }
            return toReturn;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean toReturn = false;
            for (Map.Entry<T, Set<T>> e : this.backingMap.entrySet()) {
                if (c.contains(e.getKey())) continue;
                toReturn = true;
                this.backingMap.remove(e.getKey());
            }
            return toReturn;
        }

        @Override
        public Object[] toArray() {
            return this.backingMap.keySet().toArray();
        }

        @Override
        public <Type> Type[] toArray(Type[] a) {
            return this.backingMap.keySet().toArray(a);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof SyncSet) {
                return ((Object)this.backingMap.keySet()).equals(((SyncSet)obj).backingMap.keySet());
            }
            if (obj instanceof Collection) {
                return new HashSet(this).equals(obj);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.backingMap.hashCode();
        }
    }
}

