/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportsStructureObjectSorter<O> {
    private final OWLOntology ontology;
    private final OWLOntologyManager manager;
    private final ObjectSelector<O> objectSelector;

    public ImportsStructureObjectSorter(OWLOntology ontology, OWLOntologyManager manager, ObjectSelector<O> objectSelector) {
        this.ontology = ontology;
        this.manager = manager;
        this.objectSelector = objectSelector;
    }

    public Map<OWLOntology, Set<O>> getObjects() {
        List<OWLOntology> imports = this.manager.getSortedImportsClosure(this.ontology);
        HashMap<OWLOntology, Set<O>> ontology2EntityMap = new HashMap<OWLOntology, Set<O>>();
        HashSet<O> processed = new HashSet<O>();
        for (int i = imports.size() - 1; i > -1; --i) {
            OWLOntology currentOnt = imports.get(i);
            HashSet<O> objects = new HashSet<O>();
            for (O obj : this.objectSelector.getObjects(currentOnt)) {
                if (processed.contains(obj)) continue;
                processed.add(obj);
                objects.add(obj);
            }
            ontology2EntityMap.put(currentOnt, objects);
        }
        return ontology2EntityMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ObjectSelector<O> {
        public Set<O> getObjects(OWLOntology var1);
    }
}

