/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.OWLAxiomFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologyMerger
implements OWLAxiomFilter {
    private final OWLOntologySetProvider setProvider;
    private final OWLAxiomFilter axiomFilter;
    private final boolean mergeOnlyLogicalAxioms;

    public OWLOntologyMerger(OWLOntologySetProvider setProvider) {
        this.setProvider = setProvider;
        this.axiomFilter = this;
        this.mergeOnlyLogicalAxioms = false;
    }

    public OWLOntologyMerger(OWLOntologySetProvider setProvider, boolean mergeOnlyLogicalAxioms) {
        this.setProvider = setProvider;
        this.mergeOnlyLogicalAxioms = mergeOnlyLogicalAxioms;
        this.axiomFilter = this;
    }

    public OWLOntologyMerger(OWLOntologySetProvider setProvider, OWLAxiomFilter axiomFilter) {
        this.setProvider = setProvider;
        this.axiomFilter = axiomFilter;
        this.mergeOnlyLogicalAxioms = false;
    }

    public OWLOntology createMergedOntology(OWLOntologyManager ontologyManager, IRI ontologyIRI) throws OWLOntologyCreationException {
        OWLOntology ontology = ontologyIRI != null ? ontologyManager.createOntology(ontologyIRI) : ontologyManager.createOntology();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLOntology ont : this.setProvider.getOntologies()) {
            for (OWLAxiom oWLAxiom : this.getAxioms(ont)) {
                if (!this.axiomFilter.passes(oWLAxiom)) continue;
                changes.add(new AddAxiom(ontology, oWLAxiom));
            }
        }
        ontologyManager.applyChanges(changes);
        return ontology;
    }

    private Set<? extends OWLAxiom> getAxioms(OWLOntology ont) {
        if (this.mergeOnlyLogicalAxioms) {
            return ont.getLogicalAxioms();
        }
        return ont.getAxioms();
    }

    @Override
    public boolean passes(OWLAxiom axiom) {
        return true;
    }
}

