/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.DefaultPrefixManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixOWLOntologyFormat
extends OWLOntologyFormat
implements PrefixManager {
    private static final long serialVersionUID = 7062874526250338713L;
    private final DefaultPrefixManager nsm = new DefaultPrefixManager();

    public PrefixOWLOntologyFormat() {
        this.nsm.clear();
    }

    public void setPrefix(String prefixName, String prefix) {
        if (!prefixName.endsWith(":")) {
            prefixName = prefixName + ":";
        }
        this.nsm.setPrefix(prefixName, prefix);
    }

    public void clearPrefixes() {
        this.nsm.clear();
    }

    public void copyPrefixesFrom(PrefixOWLOntologyFormat fromFormat) {
        Map<String, String> map = fromFormat.getPrefixName2PrefixMap();
        for (String pn : map.keySet()) {
            String prefix = map.get(pn);
            this.nsm.setPrefix(pn, prefix);
        }
    }

    public void copyPrefixesFrom(PrefixManager prefixManager) {
        for (String prefixName : prefixManager.getPrefixNames()) {
            String prefix = prefixManager.getPrefix(prefixName);
            this.nsm.setPrefix(prefixName, prefix);
        }
    }

    @Override
    public Set<String> getPrefixNames() {
        return this.nsm.getPrefixNames();
    }

    public void setDefaultPrefix(String namespace) {
        this.nsm.setDefaultPrefix(namespace);
    }

    @Override
    public boolean containsPrefixMapping(String prefix) {
        return this.nsm.containsPrefixMapping(prefix);
    }

    @Override
    public String getDefaultPrefix() {
        return this.nsm.getDefaultPrefix();
    }

    @Override
    public Map<String, String> getPrefixName2PrefixMap() {
        return this.nsm.getPrefixName2PrefixMap();
    }

    @Override
    public String getPrefix(String prefixName) {
        return this.nsm.getPrefix(prefixName);
    }

    @Override
    public IRI getIRI(String iri) {
        return this.nsm.getIRI(iri);
    }

    @Override
    public String getPrefixIRI(IRI iri) {
        return this.nsm.getPrefixIRI(iri);
    }
}

