/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Locale;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplBoolean;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplDouble;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplFloat;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplInteger;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplNoCompression;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class InternalsNoCache
implements OWLDataFactoryInternals {
    private final OWLDataFactory factory;
    private final OWLLiteral trueLiteral;
    private final OWLLiteral falseLiteral;
    private final boolean useCompression;

    public InternalsNoCache(OWLDataFactory f, boolean useCompression) {
        this.factory = f;
        this.trueLiteral = new OWLLiteralImplBoolean(true);
        this.falseLiteral = new OWLLiteralImplBoolean(false);
        this.useCompression = useCompression;
    }

    public void purge() {
    }

    public OWLClass getOWLClass(IRI iri) {
        return new OWLClassImpl(iri);
    }

    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return new OWLObjectPropertyImpl(iri);
    }

    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return new OWLDataPropertyImpl(iri);
    }

    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return new OWLNamedIndividualImpl(iri);
    }

    public OWLDatatype getOWLDatatype(IRI iri) {
        return new OWLDatatypeImpl(iri);
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return new OWLAnnotationPropertyImpl(iri);
    }

    public OWLLiteral getOWLLiteral(float value) {
        return new OWLLiteralImplFloat(value, this.getFloatOWLDatatype());
    }

    public OWLLiteral getOWLLiteral(String value) {
        if (this.useCompression) {
            return new OWLLiteralImpl(value, "", this.getOWLDatatype(XSDVocabulary.STRING.getIRI()));
        }
        return new OWLLiteralImplNoCompression(value, "", this.getOWLDatatype(XSDVocabulary.STRING.getIRI()));
    }

    public OWLLiteral getOWLLiteral(String literal, String lang) {
        String normalisedLang = lang == null ? "" : lang.trim().toLowerCase(Locale.ENGLISH);
        if (this.useCompression) {
            return new OWLLiteralImpl(literal, normalisedLang, null);
        }
        return new OWLLiteralImplNoCompression(literal, normalisedLang, null);
    }

    public OWLLiteral getOWLLiteral(int value) {
        return new OWLLiteralImplInteger(value, this.getIntegerOWLDatatype());
    }

    public OWLLiteral getOWLLiteral(boolean value) {
        return value ? this.trueLiteral : this.falseLiteral;
    }

    public OWLLiteral getOWLLiteral(double value) {
        return new OWLLiteralImplDouble(value, this.getDoubleOWLDatatype());
    }

    public OWLLiteral getOWLLiteral(String lexicalValue, OWLDatatype datatype) {
        OWLObject literal;
        block11: {
            if (datatype.isRDFPlainLiteral()) {
                int sep = lexicalValue.lastIndexOf(64);
                if (sep != -1) {
                    String lex = lexicalValue.substring(0, sep);
                    String lang = lexicalValue.substring(sep + 1);
                    literal = this.useCompression ? new OWLLiteralImpl(lex, lang, this.getRDFPlainLiteral()) : new OWLLiteralImplNoCompression(lex, lang, this.getRDFPlainLiteral());
                } else {
                    literal = this.useCompression ? new OWLLiteralImpl(lexicalValue, "", datatype) : new OWLLiteralImplNoCompression(lexicalValue, "", datatype);
                }
            } else {
                try {
                    if (datatype.isBoolean()) {
                        literal = (lexicalValue = lexicalValue.trim()).equals("1") ? this.getOWLLiteral(true) : (lexicalValue.equals("0") ? this.getOWLLiteral(false) : this.factory.getOWLLiteral(Boolean.parseBoolean(lexicalValue)));
                        break block11;
                    }
                    if (datatype.isFloat()) {
                        try {
                            float f = Float.parseFloat(lexicalValue);
                            literal = this.getOWLLiteral(f);
                        }
                        catch (NumberFormatException e) {
                            if (this.useCompression) {
                                literal = new OWLLiteralImpl(lexicalValue, "", datatype);
                                break block11;
                            }
                            literal = new OWLLiteralImplNoCompression(lexicalValue, "", datatype);
                        }
                        break block11;
                    }
                    literal = datatype.isDouble() ? this.getOWLLiteral(Double.parseDouble(lexicalValue)) : (datatype.isInteger() ? this.getOWLLiteral(Integer.parseInt(lexicalValue)) : (this.useCompression ? new OWLLiteralImpl(lexicalValue, "", datatype) : new OWLLiteralImplNoCompression(lexicalValue, "", datatype)));
                }
                catch (NumberFormatException e) {
                    literal = this.useCompression ? new OWLLiteralImpl(lexicalValue, "", datatype) : new OWLLiteralImplNoCompression(lexicalValue, "", datatype);
                }
            }
        }
        return literal;
    }

    public OWLDatatype getTopDatatype() {
        return this.getOWLDatatype(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
    }

    public OWLDatatype getIntegerOWLDatatype() {
        return this.getOWLDatatype(XSDVocabulary.INTEGER.getIRI());
    }

    public OWLDatatype getFloatOWLDatatype() {
        return this.getOWLDatatype(XSDVocabulary.FLOAT.getIRI());
    }

    public OWLDatatype getDoubleOWLDatatype() {
        return this.getOWLDatatype(XSDVocabulary.DOUBLE.getIRI());
    }

    public OWLDatatype getBooleanOWLDatatype() {
        return this.getOWLDatatype(XSDVocabulary.BOOLEAN.getIRI());
    }

    public OWLDatatype getRDFPlainLiteral() {
        return this.getOWLDatatype(OWLRDFVocabulary.RDF_PLAIN_LITERAL.getIRI());
    }
}

