/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLNaryClassAxiomImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEquivalentClassesAxiomImpl
extends OWLNaryClassAxiomImpl
implements OWLEquivalentClassesAxiom {
    private static final long serialVersionUID = -7012904259532092297L;
    private Set<OWLClass> namedClasses = null;

    public OWLEquivalentClassesAxiomImpl(Set<? extends OWLClassExpression> classExpressions, Collection<? extends OWLAnnotation> annotations) {
        super(classExpressions, annotations);
    }

    @Override
    public OWLEquivalentClassesAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return OWLEquivalentClassesAxiomImpl.getOWLDataFactory().getOWLEquivalentClassesAxiom(this.getClassExpressions());
    }

    @Override
    public OWLEquivalentClassesAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return OWLEquivalentClassesAxiomImpl.getOWLDataFactory().getOWLEquivalentClassesAxiom(this.getClassExpressions(), this.mergeAnnos(annotations));
    }

    @Override
    public Set<OWLEquivalentClassesAxiom> asPairwiseAxioms() {
        ArrayList<OWLClassExpression> classExpressions = new ArrayList<OWLClassExpression>(this.getClassExpressions());
        HashSet<OWLEquivalentClassesAxiom> result = new HashSet<OWLEquivalentClassesAxiom>();
        for (int i = 0; i < classExpressions.size() - 1; ++i) {
            OWLClassExpression ceI = (OWLClassExpression)classExpressions.get(i);
            OWLClassExpression ceJ = (OWLClassExpression)classExpressions.get(i + 1);
            result.add(OWLEquivalentClassesAxiomImpl.getOWLDataFactory().getOWLEquivalentClassesAxiom(ceI, ceJ));
        }
        return result;
    }

    @Override
    public boolean containsNamedEquivalentClass() {
        return !this.getNamedClasses().isEmpty();
    }

    @Override
    public boolean containsOWLNothing() {
        for (OWLClassExpression desc : this.getClassExpressions()) {
            if (!desc.isOWLNothing()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsOWLThing() {
        for (OWLClassExpression desc : this.getClassExpressions()) {
            if (!desc.isOWLThing()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLClass> getNamedClasses() {
        if (this.namedClasses == null) {
            HashSet<OWLClass> clses = new HashSet<OWLClass>(1);
            for (OWLClassExpression desc : this.getClassExpressions()) {
                if (desc.isAnonymous() || desc.isOWLNothing() || desc.isOWLThing()) continue;
                clses.add(desc.asOWLClass());
            }
            this.namedClasses = Collections.unmodifiableSet(clses);
        }
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.namedClasses);
    }

    @Override
    public Set<OWLSubClassOfAxiom> asOWLSubClassOfAxioms() {
        HashSet<OWLSubClassOfAxiom> result = new HashSet<OWLSubClassOfAxiom>();
        ArrayList<OWLClassExpression> classExpressions = new ArrayList<OWLClassExpression>(this.getClassExpressions());
        for (int i = 0; i < classExpressions.size(); ++i) {
            for (int j = 0; j < classExpressions.size(); ++j) {
                if (i == j) continue;
                result.add(OWLEquivalentClassesAxiomImpl.getOWLDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)classExpressions.get(i), (OWLClassExpression)classExpressions.get(j)));
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof OWLEquivalentClassesAxiom;
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public AxiomType<?> getAxiomType() {
        return AxiomType.EQUIVALENT_CLASSES;
    }
}

