/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLLiteralImplBoolean
extends OWLObjectImpl
implements OWLLiteral {
    private static final long serialVersionUID = -7929540842690238167L;
    private final boolean literal;
    private final OWLDatatype datatype = new OWLDatatypeImpl(OWL2Datatype.XSD_BOOLEAN.getIRI());
    private final int hashcode;

    public OWLLiteralImplBoolean(boolean literal) {
        this.literal = literal;
        this.hashcode = this.getHashCode();
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int getHashCode() {
        int hashCode = 277;
        try {
            hashCode = hashCode * 37 + this.getDatatype().hashCode();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        hashCode = hashCode * 37 + (this.literal ? 65536 : 0);
        return hashCode;
    }

    @Override
    public String getLiteral() {
        return Boolean.toString(this.literal);
    }

    public Boolean getBoolean() {
        return this.literal;
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return false;
    }

    @Override
    public boolean hasLang() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public int parseInteger() throws NumberFormatException {
        throw new NumberFormatException("this literal is not an integer but a boolean");
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean parseBoolean() throws NumberFormatException {
        return this.literal;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public double parseDouble() throws NumberFormatException {
        throw new NumberFormatException("this literal is not a double but a boolean");
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public float parseFloat() throws NumberFormatException {
        throw new NumberFormatException("this literal is not a float but a boolean");
    }

    @Override
    public String getLang() {
        return "";
    }

    @Override
    public boolean hasLang(String l) {
        return false;
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (obj instanceof OWLLiteralImplBoolean) {
                OWLLiteralImplBoolean other = (OWLLiteralImplBoolean)obj;
                return this.literal == other.literal && this.datatype.equals(other.getDatatype());
            }
            if (obj instanceof OWLLiteral) {
                return this.datatype.equals(((OWLLiteral)obj).getDatatype()) && this.getLiteral().equals(((OWLLiteral)obj).getLiteral());
            }
        }
        return false;
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        return this.datatype.compareTo(other.getDatatype());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }
}

