/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.CollectionFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAxiomImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLNaryClassAxiomImpl
extends OWLClassAxiomImpl
implements OWLNaryClassAxiom {
    private static final long serialVersionUID = 4233476602715111521L;
    private final Set<OWLClassExpression> classExpressions;

    public OWLNaryClassAxiomImpl(Set<? extends OWLClassExpression> classExpressions, Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.classExpressions = new TreeSet<OWLClassExpression>(classExpressions);
    }

    @Override
    public Set<OWLClassExpression> getClassExpressions() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.classExpressions);
    }

    @Override
    public List<OWLClassExpression> getClassExpressionsAsList() {
        return new ArrayList<OWLClassExpression>(this.classExpressions);
    }

    @Override
    public boolean contains(OWLClassExpression ce) {
        return this.classExpressions.contains(ce);
    }

    @Override
    public Set<OWLClassExpression> getClassExpressionsMinus(OWLClassExpression ... descs) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>(this.classExpressions);
        for (OWLClassExpression desc : descs) {
            result.remove(desc);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLNaryClassAxiom)) {
                return false;
            }
            return ((Object)((OWLNaryClassAxiom)obj).getClassExpressions()).equals(this.classExpressions);
        }
        return false;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return OWLNaryClassAxiomImpl.compareSets(this.classExpressions, ((OWLNaryClassAxiom)object).getClassExpressions());
    }
}

