/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.owl.owlapi.tutorial;

import java.util.HashMap;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import uk.ac.manchester.owl.owlapi.tutorial.ExistentialCollector;
import uk.ac.manchester.owl.owlapi.tutorial.SubClassCollector;

public class ClosureAxioms {
    private OWLOntologyManager manager;
    private OWLOntology ontology;
    private OWLDataFactory factory;

    public ClosureAxioms(OWLOntologyManager manager, OWLOntology ontology) throws OWLException {
        this.manager = manager;
        this.ontology = ontology;
        this.factory = manager.getOWLDataFactory();
    }

    public void addClosureAxioms(OWLClass clazz) throws OWLException {
        Set<OWLSubClassOfAxiom> axioms = this.ontology.getAxioms(AxiomType.SUBCLASS_OF);
        SubClassCollector collector = new SubClassCollector(clazz);
        for (OWLSubClassOfAxiom axiom : axioms) {
            axiom.accept(collector);
        }
        HashMap<OWLObjectPropertyExpression, Set<OWLClassExpression>> restrictions = new HashMap<OWLObjectPropertyExpression, Set<OWLClassExpression>>();
        for (OWLSubClassOfAxiom axiom : collector.getAxioms()) {
            OWLClassExpression superClass = axiom.getSuperClass();
            ExistentialCollector ec = new ExistentialCollector(restrictions);
            superClass.accept(ec);
        }
        for (OWLObjectPropertyExpression prop : restrictions.keySet()) {
            System.out.println("prop: " + prop);
            Set fillers = (Set)restrictions.get(prop);
            for (OWLClassExpression filler : fillers) {
                System.out.println("------> " + filler);
            }
            OWLObjectUnionOf union = this.factory.getOWLObjectUnionOf(fillers);
            OWLObjectAllValuesFrom universal = this.factory.getOWLObjectAllValuesFrom(prop, union);
            OWLSubClassOfAxiom newAxiom = this.factory.getOWLSubClassOfAxiom(clazz, universal);
            AddAxiom addAxiom = new AddAxiom(this.ontology, newAxiom);
            this.manager.applyChange(addAxiom);
        }
    }
}

