/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.owl.owlapi.tutorial;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistentialCollector
extends OWLClassExpressionVisitorAdapter {
    private Map<OWLObjectPropertyExpression, Set<OWLClassExpression>> restrictions;

    public ExistentialCollector(Map<OWLObjectPropertyExpression, Set<OWLClassExpression>> restrictions) {
        this.restrictions = restrictions;
    }

    @Override
    public void visit(OWLObjectIntersectionOf expression) {
        for (OWLClassExpression operand : expression.getOperands()) {
            operand.accept(this);
        }
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom classExpression) {
        Set<OWLClassExpression> fillers = this.restrictions.get(classExpression.getProperty());
        if (fillers == null) {
            fillers = new HashSet<OWLClassExpression>();
            this.restrictions.put((OWLObjectPropertyExpression)classExpression.getProperty(), fillers);
        }
        fillers.add((OWLClassExpression)classExpression.getFiller());
    }
}

