/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.owl.owlapi.tutorial.examples;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.owl.owlapi.tutorial.ClosureAxioms;

public class ClosureAxiomsExample {
    public static void usage() {
        System.out.println("Usage: ClosureAxiomsExample --input=URL --output=URL --class=URL");
    }

    public static void main(String[] args) {
        try {
            String inputOntology = null;
            String outputOntology = null;
            String classToClose = null;
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            if (inputOntology == null || outputOntology == null || classToClose == null) {
                ClosureAxiomsExample.usage();
                System.exit(1);
            }
            IRI documentIRI = IRI.create(inputOntology);
            IRI classIRI = IRI.create(classToClose);
            IRI outputDocumentIRI = IRI.create(outputOntology);
            System.out.println("Loading: " + documentIRI);
            OWLOntology ontology = manager.loadOntologyFromOntologyDocument(documentIRI);
            System.out.println("Ontology Loaded...");
            System.out.println("Logical URI : " + documentIRI);
            System.out.println("Document IRI: " + ontology.getOntologyID());
            System.out.println("Format      : " + manager.getOntologyFormat(ontology));
            ClosureAxioms closureAxioms = new ClosureAxioms(manager, ontology);
            OWLClass clazz = manager.getOWLDataFactory().getOWLClass(classIRI);
            System.out.println("Class URI   : " + classIRI);
            System.out.println(clazz);
            closureAxioms.addClosureAxioms(clazz);
            System.out.println("Saving: " + outputDocumentIRI);
            manager.saveOntology(ontology, outputDocumentIRI);
            System.out.println("Ontology Saved...");
            System.out.println("Document IRI : " + outputDocumentIRI);
            manager.removeOntology(ontology);
            System.out.println("Done");
        }
        catch (OWLException e) {
            e.printStackTrace();
        }
    }
}

