/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.owl.owlapi.tutorial.examples;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.owl.owlapi.tutorial.io.OWLTutorialSyntaxOntologyFormat;
import uk.ac.manchester.owl.owlapi.tutorial.io.OWLTutorialSyntaxOntologyStorer;

public class RenderingExample {
    public static void main(String[] args) {
        try {
            String inputOntology = null;
            String outputOntology = null;
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            if (inputOntology == null || outputOntology == null) {
                System.out.println("RenderingExample --input=URL --output=URL");
                System.exit(1);
            }
            IRI inputDocumentIRI = IRI.create(inputOntology);
            IRI outputDocumentIRI = IRI.create(outputOntology);
            OWLOntology ontology = manager.loadOntologyFromOntologyDocument(inputDocumentIRI);
            System.out.println("Ontology Loaded...");
            System.out.println("Document IRI: " + inputDocumentIRI);
            System.out.println("Logical IRI : " + ontology.getOntologyID());
            System.out.println("Format      : " + manager.getOntologyFormat(ontology));
            manager.addOntologyStorer(new OWLTutorialSyntaxOntologyStorer());
            System.out.println("Storing     : " + outputDocumentIRI);
            manager.saveOntology(ontology, (OWLOntologyFormat)new OWLTutorialSyntaxOntologyFormat(), outputDocumentIRI);
            manager.removeOntology(ontology);
            System.out.println("Done");
        }
        catch (OWLException e) {
            e.printStackTrace();
        }
    }
}

