/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.owl.owlapi.tutorial.examples;

import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.owl.owlapi.tutorial.LabelExtractor;

public class SimpleHierarchyExample {
    private static int INDENT = 4;
    private OWLReasonerFactory reasonerFactory;
    private OWLOntology ontology;
    private PrintStream out;

    public SimpleHierarchyExample(OWLOntologyManager manager, OWLReasonerFactory reasonerFactory) throws OWLException, MalformedURLException {
        this.reasonerFactory = reasonerFactory;
        this.out = System.out;
    }

    public void printHierarchy(OWLOntology ontology, OWLClass clazz) throws OWLException {
        OWLReasoner reasoner = this.reasonerFactory.createNonBufferingReasoner(ontology);
        this.ontology = ontology;
        this.printHierarchy(reasoner, clazz, 0);
        for (OWLClass cl : ontology.getClassesInSignature()) {
            if (reasoner.isSatisfiable(cl)) continue;
            this.out.println("XXX: " + this.labelFor(cl));
        }
        reasoner.dispose();
    }

    private String labelFor(OWLClass clazz) {
        LabelExtractor le = new LabelExtractor();
        Set<OWLAnnotation> annotations = clazz.getAnnotations(this.ontology);
        for (OWLAnnotation anno : annotations) {
            anno.accept(le);
        }
        if (le.getResult() != null) {
            return le.getResult().toString();
        }
        return clazz.getIRI().toString();
    }

    public void printHierarchy(OWLReasoner reasoner, OWLClass clazz, int level) throws OWLException {
        if (reasoner.isSatisfiable(clazz)) {
            for (int i = 0; i < level * INDENT; ++i) {
                this.out.print(" ");
            }
            this.out.println(this.labelFor(clazz));
            for (OWLClass child : reasoner.getSubClasses(clazz, true).getFlattened()) {
                if (child.equals(clazz)) continue;
                this.printHierarchy(reasoner, child, level + 1);
            }
        }
    }

    public static void main(String[] args) {
        try {
            IRI classIRI = null;
            String reasonerFactoryClassName = null;
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            System.out.println(args[0]);
            IRI documentIRI = IRI.create(args[0]);
            OWLOntology ontology = manager.loadOntologyFromOntologyDocument(documentIRI);
            System.out.println("Ontology Loaded...");
            System.out.println("Document IRI: " + documentIRI);
            System.out.println("Ontology : " + ontology.getOntologyID());
            System.out.println("Format      : " + manager.getOntologyFormat(ontology));
            SimpleHierarchyExample simpleHierarchy = new SimpleHierarchyExample(manager, (OWLReasonerFactory)Class.forName(reasonerFactoryClassName).newInstance());
            if (classIRI == null) {
                classIRI = OWLRDFVocabulary.OWL_THING.getIRI();
            }
            OWLClass clazz = manager.getOWLDataFactory().getOWLClass(classIRI);
            System.out.println("Class       : " + classIRI);
            simpleHierarchy.printHierarchy(ontology, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

