/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.owl.owlapi.tutorial.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.QNameShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLTutorialSyntaxObjectRenderer
implements OWLObjectVisitor {
    private final OWLOntology ontology;
    private final ShortFormProvider shortForms;
    private final Writer writer;
    private int pos;
    int lastNewLinePos;
    private final boolean tables = true;
    private static int TABLE_COLUMNS = 3;

    public String labelFor(OWLEntity entity) {
        return this.shortForms.getShortForm(entity);
    }

    public OWLTutorialSyntaxObjectRenderer(OWLOntology ontology, Writer writer) {
        this.ontology = ontology;
        this.writer = writer;
        this.shortForms = new QNameShortFormProvider();
    }

    private void write(String s) {
        try {
            int newLineIndex = s.indexOf(10);
            if (newLineIndex != -1) {
                this.lastNewLinePos = this.pos + newLineIndex;
            }
            this.pos += s.length();
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void write(IRI iri) {
        this.write("<");
        this.write(iri.toQuotedString());
        this.write(">");
    }

    public void header() {
        this.write("<html>\n");
        this.write("<head>\n");
        this.write("<style>\n");
        this.write("body { font-family: sans-serif; }\n");
        this.write(".key { color: grey; font-size: 75%; }\n");
        this.write(".op { color: grey; }\n");
        this.write(".cl { color: #800; }\n");
        this.write(".pr { color: #080; }\n");
        this.write(".in { color: #008; }\n");
        this.write(".box { border: solid 1px grey; padding: 10px; margin: 10px; }\n");
        int width = 100 / TABLE_COLUMNS;
        this.write("table { width: 100%; }\n");
        this.write("td { padding-left: 10px; padding-right: 10px; width: " + width + "%;}\n");
        this.write("</style>\n");
        this.write("<body>\n");
    }

    public void footer() {
        this.write("</body>\n");
        this.write("</html>\n");
    }

    private void writeCollection(Collection<? extends OWLObject> objects) {
        this.writeTable(objects);
    }

    private void writeTable(Collection<? extends OWLObject> objects) {
        this.writeTableStart();
        int count = 0;
        Iterator<? extends OWLObject> it = objects.iterator();
        while (it.hasNext()) {
            if (count % TABLE_COLUMNS == 0) {
                if (count > 0) {
                    this.writeTableRowEnd();
                }
                this.writeTableRowStart();
            }
            this.writeTableCellStart();
            it.next().accept(this);
            this.writeTableCellEnd();
            ++count;
        }
        this.writeTableRowEnd();
        this.writeTableEnd();
    }

    private void writeList(Collection<? extends OWLObject> objects) {
        this.writeListStart();
        Iterator<? extends OWLObject> it = objects.iterator();
        while (it.hasNext()) {
            this.writeListItemStart();
            it.next().accept(this);
            this.writeListItemEnd();
        }
        this.writeListEnd();
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.header();
        this.write("<h1>");
        this.write(ontology.getOntologyID().toString());
        this.write("</h1>\n");
        this.write("<div>");
        this.write("<div class='box'>\n");
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>(ontology.getAxioms());
        axioms.removeAll(ontology.getImportsDeclarations());
        for (OWLImportsDeclaration decl : ontology.getImportsDeclarations()) {
            this.write("Imports: ");
            this.write(decl.getURI().toString());
            this.write("\n");
        }
        this.write("<h2>Classes</h2>\n");
        this.writeCollection(ontology.getClassesInSignature());
        this.write("</div>\n");
        this.write("<div class='box'>\n");
        this.write("<h2>Properties</h2>\n");
        this.writeCollection(ontology.getObjectPropertiesInSignature());
        this.writeCollection(ontology.getDataPropertiesInSignature());
        this.write("</div>\n");
        this.write("<div class='box'>\n");
        this.write("<h2>Individuals</h2>\n");
        this.writeCollection(ontology.getIndividualsInSignature());
        this.write("</div>");
        this.write("<div>");
        this.write("<div class='box'>");
        this.write("<h2>Axioms</h2>\n");
        this.writeListStart();
        for (OWLAxiom ax : ontology.getAxioms()) {
            this.writeListItemStart();
            ax.accept(this);
            this.writeListEnd();
        }
        this.writeListEnd();
        this.write("</div>");
        this.footer();
    }

    public void write(String str, OWLObject o) {
        this.write(str);
        this.write("(");
        o.accept(this);
        this.write(")");
    }

    private void write(Collection<? extends OWLObject> objects, String separator) {
        Iterator<? extends OWLObject> it = objects.iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(separator);
            this.writeSpace();
        }
    }

    private void write(Collection<? extends OWLObject> objects) {
        this.write(objects, "");
    }

    public void writeOpenBracket() {
        this.write("(");
    }

    public void writeCloseBracket() {
        this.write(")");
    }

    public void writeSpace() {
        this.write(" ");
    }

    public void writeAnnotations(OWLAxiom ax) {
    }

    public void writeListStart() {
        this.write("<ul>\n");
    }

    public void writeListEnd() {
        this.write("</ul>\n");
    }

    public void writeTableStart() {
        this.write("<table>\n");
    }

    public void writeTableEnd() {
        this.write("</table>\n");
    }

    public void writeTableRowStart() {
        this.write("<tr>\n");
    }

    public void writeTableRowEnd() {
        this.write("</tr>\n");
    }

    public void writeTableCellStart() {
        this.write("<td>\n");
    }

    public void writeTableCellEnd() {
        this.write("</td>\n");
    }

    public void writeListItemStart() {
        this.write("<li>\n");
    }

    public void writeListItemEnd() {
        this.write("</li>\n");
    }

    public void writePropertyCharacteristic(String str, OWLAxiom ax, OWLPropertyExpression prop) throws OWLRuntimeException {
        this.write(this.keyword(str));
        this.writeSpace();
        prop.accept(this);
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("asymmetric", axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept(this);
        this.write(this.keyword(":"));
        this.writeSpace();
        axiom.getClassExpression().accept(this);
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        this.writeSpace();
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(this.keyword("domain"));
        this.writeSpace();
        axiom.getDomain().accept(this);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(this.keyword("range"));
        this.writeSpace();
        ((OWLDataRange)axiom.getRange()).accept(this);
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSpace();
        this.write(this.keyword("subProperty"));
        this.writeSpace();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.write(axiom.getIndividuals(), this.keyword("!="));
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.write(axiom.getClassExpressions(), this.keyword("|"));
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), this.keyword("|"));
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.write(this.keyword("disjoint"));
        this.write(axiom.getProperties(), this.keyword("|"));
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        axiom.getOWLClass().accept(this);
        this.writeSpace();
        this.write(this.keyword("=="));
        this.writeSpace();
        this.write(axiom.getClassExpressions(), this.keyword("|"));
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.write(axiom.getClassExpressions(), this.keyword("=="));
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), this.keyword("=="));
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), this.keyword("=="));
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writePropertyCharacteristic("functional", axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("functional", axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    public void visit(OWLImportsDeclaration axiom) {
        this.write(this.keyword("imports"));
        this.write(axiom.getIRI());
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("inversefunctional", axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        axiom.getFirstProperty().accept(this);
        this.writeSpace();
        this.write(this.keyword("inverse"));
        this.writeSpace();
        axiom.getSecondProperty().accept(this);
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("Irreflexive", axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        this.writeSpace();
        this.write(this.keyword("notvalue"));
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        this.writeSpace();
        this.write(this.keyword("notvalue"));
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.write("chain");
        this.writeOpenBracket();
        this.write(axiom.getPropertyChain());
        this.writeCloseBracket();
        this.writeSpace();
        this.write(this.keyword("subProperty"));
        this.writeSpace();
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(this.keyword("domain"));
        this.writeSpace();
        axiom.getDomain().accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(this.keyword("range"));
        this.writeSpace();
        ((OWLClassExpression)axiom.getRange()).accept(this);
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSpace();
        this.write(this.keyword("subProperty"));
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("reflexive", axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.write(axiom.getIndividuals(), this.keyword("="));
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept(this);
        this.writeSpace();
        this.write(this.keyword("subClass"));
        this.writeSpace();
        axiom.getSuperClass().accept(this);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("symmetric", axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("transitive", axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLClass desc) {
        this.write("<span class='cl'>" + this.labelFor(desc) + "</span>");
    }

    private <R extends OWLPropertyRange, P extends OWLPropertyExpression<R, P>, F extends OWLPropertyRange> void writeRestriction(String str, OWLCardinalityRestriction<R, P, F> restriction) {
        this.write(str);
        this.writeOpenBracket();
        this.write(Integer.toString(restriction.getCardinality()));
        this.writeSpace();
        restriction.getProperty().accept(this);
        if (restriction.isQualified()) {
            this.writeSpace();
            restriction.getFiller().accept(this);
        }
        this.writeCloseBracket();
    }

    private void writeRestriction(String str, OWLQuantifiedDataRestriction restriction) {
        this.writeRestriction(str, (OWLPropertyExpression)restriction.getProperty(), (OWLObject)restriction.getFiller());
    }

    private void writeRestriction(String str, OWLQuantifiedObjectRestriction restriction) {
        this.writeRestriction(str, (OWLPropertyExpression)restriction.getProperty(), (OWLObject)restriction.getFiller());
    }

    private void writeRestriction(String str, OWLPropertyExpression prop, OWLObject filler) throws OWLRuntimeException {
        this.write(str);
        this.writeOpenBracket();
        prop.accept(this);
        this.writeSpace();
        filler.accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataAllValuesFrom desc) {
        this.writeRestriction(this.operator("only"), desc);
    }

    @Override
    public void visit(OWLDataExactCardinality desc) {
        this.writeRestriction("exact", desc);
    }

    @Override
    public void visit(OWLDataMaxCardinality desc) {
        this.writeRestriction("atmost", desc);
    }

    @Override
    public void visit(OWLDataMinCardinality desc) {
        this.writeRestriction("atleast", desc);
    }

    @Override
    public void visit(OWLDataSomeValuesFrom desc) {
        this.writeRestriction(this.operator("some"), desc);
    }

    @Override
    public void visit(OWLDataHasValue desc) {
        this.writeRestriction("has-value", (OWLPropertyExpression)desc.getProperty(), (OWLObject)desc.getValue());
    }

    @Override
    public void visit(OWLObjectAllValuesFrom desc) {
        this.writeRestriction(this.operator("only"), desc);
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        this.write(this.operator("not"), desc.getOperand());
    }

    @Override
    public void visit(OWLObjectExactCardinality desc) {
        this.writeRestriction("exact", desc);
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.writeOpenBracket();
        this.write(desc.getOperands(), this.keyword("and"));
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectMaxCardinality desc) {
        this.writeRestriction("atmost", desc);
    }

    @Override
    public void visit(OWLObjectMinCardinality desc) {
        this.writeRestriction("atleast", desc);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.write(this.operator("one-of"));
        this.writeOpenBracket();
        this.write(desc.getIndividuals());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectHasSelf desc) {
        this.write("self", (OWLObject)desc.getProperty());
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom desc) {
        this.writeRestriction(this.operator("some"), desc);
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.writeOpenBracket();
        this.write(desc.getOperands(), " or ");
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectHasValue desc) {
        this.writeRestriction("hasValue", (OWLPropertyExpression)desc.getProperty(), (OWLObject)desc.getValue());
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.write(this.operator("not"), node.getDataRange());
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.write(this.operator("one-of"));
        this.write("(");
        this.write(node.getValues());
        this.write(")");
    }

    @Override
    public void visit(OWLDatatype node) {
        this.write("Datatype");
        this.writeOpenBracket();
        this.write(node.getIRI());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.write("DatatypeRestriction");
        this.writeOpenBracket();
        node.getDatatype().accept(this);
        for (OWLFacetRestriction restriction : node.getFacetRestrictions()) {
            this.writeSpace();
            restriction.accept(this);
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.write(node.getFacet().getIRI());
        this.writeSpace();
        node.getFacetValue().accept(this);
    }

    @Override
    public void visit(OWLLiteral node) {
        this.write("\"");
        this.write(node.getLiteral());
        this.write("\"");
        if (node.hasLang()) {
            this.write("@");
            this.write(node.getLang());
        } else {
            this.write("^^");
            this.write(node.getDatatype().getIRI());
        }
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.write("<span class='pr'>" + this.labelFor(property) + "</span>");
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.write("<span class='pr'>" + this.labelFor(property) + "</span>");
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.write("inv");
        this.writeOpenBracket();
        property.getInverse().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.write("<span class='in'>" + this.labelFor(individual) + "</span>");
    }

    @Override
    public void visit(SWRLRule rule) {
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLClassAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLVariable node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(IRI iri) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(OWLAnnotation node) {
        throw new OWLRuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        throw new OWLRuntimeException("NOT IMPLEMENTED");
    }

    public String keyword(String str) {
        return "<span class='key'>" + str + "</span>";
    }

    public String operator(String str) {
        return "<span class='op'>" + str + "</span>";
    }
}

