/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.protege;

import com.racersystems.protege.update.RacerProUpdateInfo;
import java.io.File;
import java.io.IOException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.protege.common.CommonProtegeProperties;

public class RacerProInstalledBinaryInfo {
    public static final String racerWindowsBinaryName = "RacerPro.exe";
    public static final String racerLinuxBinaryName = "RacerPro";
    public static final String racerMacOsXBinaryName = "RacerPro";
    private static final String windowsDirectoryName = "win";
    private static final String linuxDirectoryName = "linux";
    private static final String macOsXDirectoryName = "mac";
    private static final String racerDirectoryName = "RacerPro";
    private File binaryAbsoluteFile;
    private File binaryDirectory;
    private static RacerProInstalledBinaryInfo theInstance;
    private Version version;
    private String osID;
    private OSTYPE osType;

    public static RacerProInstalledBinaryInfo getInstance() {
        if (theInstance == null) {
            throw new NullPointerException("RacerInstalledBinaryInfo has not been initialized");
        }
        return theInstance;
    }

    protected RacerProInstalledBinaryInfo(BundleContext bundleContext) {
        Object object;
        File file;
        String string = bundleContext.getProperty("org.osgi.framework.os.name");
        String string2 = bundleContext.getProperty("org.osgi.framework.processor");
        File file2 = new File(System.getProperty("org.protege.plugin.dir"));
        String string3 = file2.getAbsoluteFile().getParentFile().getAbsolutePath() + File.separator + "RacerPro" + File.separator;
        String string4 = file2.getAbsoluteFile().getParentFile().getAbsolutePath() + File.separator + "RacerPro";
        File file3 = new File(string4);
        boolean bl = true;
        try {
            if (!file3.exists()) {
                bl = file3.mkdir();
            } else {
                file = File.createTempFile("lock", "tmp", file3);
                file.deleteOnExit();
            }
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        if (bl) {
            string3 = string4 + File.separator;
        } else {
            try {
                file = CommonProtegeProperties.getUserPluginDirectory();
                object = file.getAbsoluteFile().getParentFile().getAbsolutePath() + File.separator + "RacerPro";
                bl = true;
                try {
                    file3 = new File((String)object);
                    if (!file3.exists()) {
                        bl = file3.mkdir();
                    } else {
                        File file4 = File.createTempFile("lock", "tmp", file3);
                        file4.deleteOnExit();
                    }
                }
                catch (SecurityException securityException) {
                    bl = false;
                }
                catch (IOException iOException) {
                    bl = false;
                }
                if (bl) {
                    string3 = (String)object + File.separator;
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        this.createDirectory(string3);
        this.osID = "";
        if ("macos".equalsIgnoreCase(string) || "macosx".equalsIgnoreCase(string)) {
            this.osID = this.osID + macOsXDirectoryName;
            this.osType = OSTYPE.MAC;
        } else if (linuxDirectoryName.equalsIgnoreCase(string)) {
            this.osID = this.osID + linuxDirectoryName;
            this.osType = OSTYPE.LINUX;
        } else if (string.startsWith(windowsDirectoryName)) {
            this.osID = this.osID + windowsDirectoryName;
            this.osType = OSTYPE.WIN;
        } else {
            this.osType = OSTYPE.OTHER;
        }
        this.osID = "x86".equals(string2) ? this.osID + "32" : ("powerpc".equalsIgnoreCase(string2) ? this.osID + "32" : ("Sparc".equals(string2) ? this.osID + "32" : this.osID + "64"));
        string3 = string3 + this.osID + File.separator;
        this.createDirectory(string3);
        this.binaryDirectory = new File(string3);
        file = new File(string3 + "update.properties");
        try {
            object = RacerProUpdateInfo.read(file.toURI().toURL());
            this.version = ((RacerProUpdateInfo)object).getAvailableVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("macos".equalsIgnoreCase(string) || "macosx".equalsIgnoreCase(string)) {
            string3 = string3 + "RacerPro";
        } else if (linuxDirectoryName.equalsIgnoreCase(string)) {
            string3 = string3 + "RacerPro";
        } else if (string.startsWith(windowsDirectoryName)) {
            string3 = string3 + racerWindowsBinaryName;
        }
        this.binaryAbsoluteFile = new File(string3);
        if (this.osType != OSTYPE.WIN) {
            try {
                Runtime.getRuntime().exec("chmod 755 " + this.binaryAbsoluteFile.toString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        theInstance = this;
    }

    public String getOSIdentifier() {
        return this.osID;
    }

    public OSTYPE getOSType() {
        return this.osType;
    }

    private void CheckDirectoryAccess() {
    }

    private final boolean createDirectory(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return file.mkdir();
        }
        return true;
    }

    public File getBinaryAbsoluteFile() {
        return this.binaryAbsoluteFile;
    }

    public boolean isBinaryFileAvailable() {
        return this.binaryAbsoluteFile.exists();
    }

    public Version getInstalledBinaryVersion() {
        return this.version;
    }

    public File getBinaryInstallationDirectory() {
        return this.binaryDirectory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSTYPE {
        WIN,
        LINUX,
        MAC,
        OTHER;

    }
}

