/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.protege;

import com.racersystems.protege.ReasonerFactory;
import com.racersystems.protege.preferences.RacerProPreferences;
import com.racersystems.racer.Configuration;
import com.racersystems.racer.Translator;
import java.util.Vector;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;

public class Reasoner
extends com.racersystems.racer.Reasoner {
    private Process process;

    public Reasoner(Process process, OWLOntology oWLOntology, Configuration configuration, BufferingMode bufferingMode) {
        super(oWLOntology, configuration, bufferingMode);
        this.process = process;
    }

    protected Translator createRacerTranslator() {
        return new Translator(this.getOWLOntologyManager(), this.getReasonerConfiguration(), this.serverAdapter.getOutputWriter(), this.serverAdapter.getInputReader()){

            public void disposeKnowledgeBase() {
                if (new RacerProPreferences().isDisposeReasonerOnClose()) {
                    super.disposeKnowledgeBase();
                }
            }
        };
    }

    protected void disposeSilently() {
        if (this.process != null) {
            this.racerTranslator.shutdown();
            super.disposeSilently();
        }
    }

    protected void disposeInternaly() {
        this.racerTranslator.setSimplifiedRacerDispose(true);
        super.dispose();
        this.process = null;
    }

    public void dispose() {
        ReasonerFactory.disposeRunningRacerReasoner(this.process, this);
    }

    public void precomputeInferences(InferenceType ... inferenceTypeArray) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        if (new RacerProPreferences().isDisableABoxRealization()) {
            Vector<InferenceType> vector = new Vector<InferenceType>();
            block10: for (InferenceType inferenceType : inferenceTypeArray) {
                switch (inferenceType) {
                    case CLASS_HIERARCHY: {
                        vector.add(inferenceType);
                        continue block10;
                    }
                    case DATA_PROPERTY_HIERARCHY: {
                        vector.add(inferenceType);
                        continue block10;
                    }
                    case OBJECT_PROPERTY_HIERARCHY: {
                        vector.add(inferenceType);
                        continue block10;
                    }
                    case CLASS_ASSERTIONS: {
                        continue block10;
                    }
                    case DATA_PROPERTY_ASSERTIONS: {
                        continue block10;
                    }
                    case DIFFERENT_INDIVIDUALS: {
                        continue block10;
                    }
                    case DISJOINT_CLASSES: {
                        vector.add(inferenceType);
                        continue block10;
                    }
                    case OBJECT_PROPERTY_ASSERTIONS: {
                        continue block10;
                    }
                }
            }
            super.precomputeInferences(vector.toArray(new InferenceType[vector.size()]));
        } else {
            super.precomputeInferences(inferenceTypeArray);
        }
    }
}

