/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.protege;

import com.racersystems.protege.RacerProBinariesNotFoundException;
import com.racersystems.protege.RacerProInstalledBinaryInfo;
import com.racersystems.protege.RacerProRemoteRacerNotFoundException;
import com.racersystems.protege.RacerProStartingReasonerException;
import com.racersystems.protege.Reasoner;
import com.racersystems.protege.logging.LogFileManager;
import com.racersystems.protege.preferences.RacerProPreferences;
import com.racersystems.protege.ui.ProtegeReasonerMenuUpdater;
import com.racersystems.racer.Configuration;
import com.racersystems.racer.RacerRuntimeException;
import com.racersystems.racer.Reasoner;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import org.protege.editor.owl.model.inference.NoOpReasonerFactory;
import org.protege.editor.owl.model.inference.OWLReasonerManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class ReasonerFactory
implements OWLReasonerFactory {
    static AtomicInteger numberOfReasoners = new AtomicInteger(0);
    private OWLReasonerManager manager;
    private Reasoner.ReasonerFactory factory = new Reasoner.ReasonerFactory();

    public ReasonerFactory(OWLReasonerManager oWLReasonerManager) {
        this.manager = oWLReasonerManager;
    }

    private void showShippedRacerProBinariesNotFound() {
        JOptionPane.showMessageDialog(null, "The RacerPro plugin tried to use the internal RacerPro but could not find \na valid binary. \nThe executable will be downloaded when starting Prot\u00e9g\u00e9.\nHowever,  you can also configure the plugin to use an external RacerPro (see configuration dialog).\n\nSwitching to \"None reasoner\".", "RacerPro binaries are missing", 0);
    }

    private void showExternalRacerProBinariesNotFound() {
        JOptionPane.showMessageDialog(null, "The RacerPro plugin tried to start an external RacerPro but could not find \na valid binary. \nSwitching to \"None reasoner\".", "RacerPro binaries are missing", 0);
    }

    private void showStartingRacerProException(boolean bl) {
        JOptionPane.showMessageDialog(null, "Could not start the " + (bl ? "internal " : "external ") + "RacerPro.\n" + (bl ? "" : "Please make sure that the path to the external RacerPro binary file is valid:\n" + new RacerProPreferences().getExternalRacerBinaryPath() + "\nSee " + "the RacerPro plugin configuration dialog.") + "\n\n" + "Switching to \"None reasoner\".", "Error starting RacerPro", 0);
    }

    protected Process startRacer() {
        if (numberOfReasoners.intValue() > 1) {
            return null;
        }
        RacerProPreferences racerProPreferences = RacerProPreferences.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (racerProPreferences.isStartRacerEnabled()) {
            if (!this.checkForRunningRacer("127.0.0.1", racerProPreferences.getPort(), 1)) {
                Object object;
                RacerProInstalledBinaryInfo racerProInstalledBinaryInfo = RacerProInstalledBinaryInfo.getInstance();
                if (!racerProInstalledBinaryInfo.isBinaryFileAvailable() && racerProPreferences.isIntegratedRacerEnabled()) {
                    this.showShippedRacerProBinariesNotFound();
                    throw new RacerProBinariesNotFoundException();
                }
                if (racerProPreferences.isIntegratedRacerEnabled()) {
                    arrayList.add(racerProInstalledBinaryInfo.getBinaryAbsoluteFile().getAbsolutePath());
                } else {
                    object = racerProPreferences.getExternalRacerBinaryPath();
                    if (!new File((String)object).exists()) {
                        this.showExternalRacerProBinariesNotFound();
                        throw new RacerProBinariesNotFoundException();
                    }
                    arrayList.add((String)object);
                }
                if (racerProInstalledBinaryInfo.getOSType() == RacerProInstalledBinaryInfo.OSTYPE.WIN) {
                    arrayList.add("+cx");
                }
                arrayList.add("--");
                if (racerProPreferences.isLoggingEnabled()) {
                    arrayList.add("-logging");
                    object = new LogFileManager();
                    ((LogFileManager)object).cleanUpLogFiles();
                    arrayList.add(((LogFileManager)object).getLogFile());
                }
                arrayList.add("-http");
                arrayList.add("0");
                arrayList.add("-u");
                arrayList.add("-ef");
                arrayList.add("@UTF8");
                object = arrayList.size() > 2 ? new ProcessBuilder(arrayList) : new ProcessBuilder((String)arrayList.get(0));
                ((ProcessBuilder)object).redirectErrorStream(true);
                try {
                    Process process = ((ProcessBuilder)object).start();
                    final InputStream inputStream = process.getErrorStream();
                    final InputStream inputStream2 = process.getInputStream();
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));
                            PrintStream printStream = new PrintStream(new DevNullStream());
                            String string = "";
                            try {
                                while ((string = bufferedReader.readLine()) != null) {
                                    printStream.println(string);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    Thread thread2 = new Thread(new Runnable(){

                        public void run() {
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                            PrintStream printStream = new PrintStream(new DevNullStream());
                            String string = "";
                            try {
                                while ((string = bufferedReader.readLine()) != null) {
                                    printStream.println(string);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    thread.start();
                    thread2.start();
                    InetSocketAddress inetSocketAddress = new InetSocketAddress("127.0.0.1", racerProPreferences.getLocalRacerPort());
                    int n = 0;
                    boolean bl = false;
                    while (true) {
                        try {
                            Socket socket = new Socket(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                            socket.close();
                            bl = true;
                        }
                        catch (Exception exception) {
                            ++n;
                            try {
                                Thread.currentThread();
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (n <= 10000) continue;
                        }
                        break;
                    }
                    if (bl) {
                        numberOfReasoners.incrementAndGet();
                        return process;
                    }
                    this.showStartingRacerProException(racerProPreferences.isIntegratedRacerEnabled());
                    throw new RacerProStartingReasonerException();
                }
                catch (IOException iOException) {
                    this.showStartingRacerProException(racerProPreferences.isIntegratedRacerEnabled());
                    throw new RacerProStartingReasonerException();
                }
                catch (Exception exception) {
                    this.showStartingRacerProException(racerProPreferences.isIntegratedRacerEnabled());
                    throw new RacerProStartingReasonerException();
                }
            }
            JOptionPane.showMessageDialog(null, "RacerPro is alrady running on port " + racerProPreferences.getPort() + "\nConnected to the running RacerPro", "RacerPro", 1);
        } else if (!this.checkForRunningRacer(racerProPreferences.getRemoteRacerAddress(), racerProPreferences.getRemoteRacerPort(), 4)) {
            JOptionPane.showMessageDialog(null, "Could not connect to a running RacerPro listening at TCP \n(remote address " + racerProPreferences.getRemoteRacerAddress() + " and TCP port number " + racerProPreferences.getRemoteRacerPort() + ")\n" + "Please make shure that RacerPro is running \n\n" + "Switching to \"None reasoner\".", "Could not connect to running RacerPro", 0);
            throw new RacerProRemoteRacerNotFoundException(racerProPreferences.getRemoteRacerAddress(), racerProPreferences.getRemoteRacerPort());
        }
        return null;
    }

    private boolean checkForRunningRacer(String string, int n, int n2) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        int n3 = 0;
        while (true) {
            Socket socket = null;
            PrintWriter printWriter = null;
            BufferedReader bufferedReader = null;
            try {
                socket = new Socket(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
                printWriter.println("(get-racer-version)");
                printWriter.flush();
                InputStreamReader inputStreamReader = new InputStreamReader(socket.getInputStream(), "UTF-8");
                bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = bufferedReader.readLine();
                printWriter.close();
                inputStreamReader.close();
                if (string2.startsWith(":answer")) {
                    return true;
                }
                socket.close();
                return true;
            }
            catch (Exception exception) {
                ++n3;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (printWriter != null) {
                    printWriter.close();
                }
                if (bufferedReader == null) continue;
                try {
                    bufferedReader.close();
                    continue;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                if (n3 <= n2) continue;
                return false;
            }
            break;
        }
    }

    private String readFromSocket(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n = inputStream.read();
            byteArrayOutputStream.write(n);
            while (n != 10) {
                n = inputStream.read();
                if (n == 10) continue;
                byteArrayOutputStream.write(n);
            }
        }
        catch (IOException iOException) {
            throw new RacerRuntimeException(iOException);
        }
        String string = byteArrayOutputStream.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumberOfRunningRacerReasoners() {
        AtomicInteger atomicInteger = numberOfReasoners;
        synchronized (atomicInteger) {
            return numberOfReasoners.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeRunningRacerReasoner(Process process, Reasoner reasoner) {
        AtomicInteger atomicInteger = numberOfReasoners;
        synchronized (atomicInteger) {
            if (process != null) {
                if (numberOfReasoners.decrementAndGet() < 1) {
                    reasoner.disposeSilently();
                } else {
                    reasoner.disposeInternaly();
                }
            } else {
                reasoner.disposeInternaly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean destroyRunningRacer(Process process) {
        AtomicInteger atomicInteger = numberOfReasoners;
        synchronized (atomicInteger) {
            if (numberOfReasoners.decrementAndGet() < 1 && RacerProPreferences.getInstance().isStartRacerEnabled()) {
                process.destroy();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delegateReasonerdispose(Process process, Reasoner reasoner) {
        AtomicInteger atomicInteger = numberOfReasoners;
        synchronized (atomicInteger) {
            if (numberOfReasoners.decrementAndGet() < 1 && RacerProPreferences.getInstance().isStartRacerEnabled()) {
                process.destroy();
                return true;
            }
            reasoner.dispose();
        }
        return false;
    }

    protected Configuration getConfiguration(OWLReasonerConfiguration oWLReasonerConfiguration) {
        if (oWLReasonerConfiguration instanceof Configuration) {
            return (Configuration)oWLReasonerConfiguration;
        }
        return new Configuration(oWLReasonerConfiguration);
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology oWLOntology) {
        try {
            Process process = this.startRacer();
            return new Reasoner(process, oWLOntology, new Configuration(), BufferingMode.NON_BUFFERING);
        }
        catch (RacerProBinariesNotFoundException racerProBinariesNotFoundException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createNonBufferingReasoner(oWLOntology);
        }
        catch (RacerProRemoteRacerNotFoundException racerProRemoteRacerNotFoundException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createNonBufferingReasoner(oWLOntology);
        }
        catch (RacerProStartingReasonerException racerProStartingReasonerException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createNonBufferingReasoner(oWLOntology);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "An exception raised while connecting to Racerpro\n\n\n\nSwitching to \"None reasoner\".", "RacerPro exception", 0);
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createNonBufferingReasoner(oWLOntology);
        }
    }

    public OWLReasoner createReasoner(OWLOntology oWLOntology) {
        try {
            Process process = this.startRacer();
            return new Reasoner(process, oWLOntology, new Configuration(), BufferingMode.BUFFERING);
        }
        catch (RacerProBinariesNotFoundException racerProBinariesNotFoundException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createReasoner(oWLOntology);
        }
        catch (RacerProRemoteRacerNotFoundException racerProRemoteRacerNotFoundException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createNonBufferingReasoner(oWLOntology);
        }
        catch (RacerProStartingReasonerException racerProStartingReasonerException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createNonBufferingReasoner(oWLOntology);
        }
        catch (RacerRuntimeException racerRuntimeException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createReasoner(oWLOntology);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "An exception raised while connecting to Racerpro\n\n\n\nSwitching to \"None reasoner\".", "RacerPro exception", 0);
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createReasoner(oWLOntology);
        }
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration) throws IllegalConfigurationException {
        try {
            Process process = this.startRacer();
            return new Reasoner(process, oWLOntology, this.getConfiguration(oWLReasonerConfiguration), BufferingMode.NON_BUFFERING);
        }
        catch (RacerProBinariesNotFoundException racerProBinariesNotFoundException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createNonBufferingReasoner(oWLOntology);
        }
        catch (RacerProRemoteRacerNotFoundException racerProRemoteRacerNotFoundException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createNonBufferingReasoner(oWLOntology);
        }
        catch (RacerProStartingReasonerException racerProStartingReasonerException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createNonBufferingReasoner(oWLOntology);
        }
    }

    public OWLReasoner createReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration) throws IllegalConfigurationException {
        try {
            Process process = this.startRacer();
            return new Reasoner(process, oWLOntology, this.getConfiguration(oWLReasonerConfiguration), BufferingMode.BUFFERING);
        }
        catch (RacerProBinariesNotFoundException racerProBinariesNotFoundException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createReasoner(oWLOntology);
        }
        catch (RacerProRemoteRacerNotFoundException racerProRemoteRacerNotFoundException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createNonBufferingReasoner(oWLOntology);
        }
        catch (RacerProStartingReasonerException racerProStartingReasonerException) {
            ProtegeReasonerMenuUpdater protegeReasonerMenuUpdater = new ProtegeReasonerMenuUpdater();
            protegeReasonerMenuUpdater.setNoneReasoner(this.manager);
            return new NoOpReasonerFactory().createNonBufferingReasoner(oWLOntology);
        }
    }

    public String getReasonerName() {
        return this.factory.getReasonerName();
    }

    class DevNullStream
    extends OutputStream {
        DevNullStream() {
        }

        public void write(int n) throws IOException {
        }
    }
}

