/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.protege.logging;

import com.racersystems.protege.preferences.RacerProPreferences;
import java.io.File;
import java.io.FilenameFilter;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;

public class LogFileManager {
    private String logFilePrefix = "racer";
    private String logFileSuffix = ".log";
    private String separator = "-";
    private int maxNumberOfFiles = 100;

    public String getLogFilePrefix() {
        return this.logFilePrefix;
    }

    protected String generateFileName() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Calendar calendar = Calendar.getInstance();
        String string = dateFormat.format(calendar.getTime());
        string = string.replace(" ", "_");
        string = string.replace(".", "-");
        string = string.replace(":", "-");
        return this.logFilePrefix + this.separator + string + this.logFileSuffix;
    }

    public String getLogFile() {
        this.cleanUpLogFiles();
        String string = RacerProPreferences.getInstance().getLoggingDirectory();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return RacerProPreferences.getInstance().getLoggingDirectory() + File.separator + this.generateFileName();
    }

    public void cleanUpLogFiles() {
        File file = new File(RacerProPreferences.getInstance().getLoggingDirectory());
        if (!file.exists()) {
            return;
        }
        Object[] objectArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith(LogFileManager.this.logFilePrefix + LogFileManager.this.separator);
            }
        });
        if (objectArray == null) {
            return;
        }
        Arrays.sort(objectArray);
        if (objectArray.length > this.maxNumberOfFiles) {
            int n = 0;
            for (Object object : objectArray) {
                ((File)object).delete();
                if (n > objectArray.length - this.maxNumberOfFiles) {
                    return;
                }
                ++n;
            }
        }
    }
}

