/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.protege.preferences;

import com.racersystems.protege.RacerProInstalledBinaryInfo;
import com.racersystems.protege.preferences.RacerProPreferences;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;

public class RacerProPreferencePanel
extends OWLPreferencesPanel
implements ActionListener {
    private JRadioButton startRacerPro;
    private JRadioButton connectRacerPro;
    private JRadioButton useIntegratedRacerPro;
    private JRadioButton useExternalRacerPro;
    protected JTextField binaryField;
    private JTextField localRacerPort;
    protected JTextField remoteRacerProAdress;
    protected JTextField remoteRacerProPort;
    protected JCheckBox checkForUpdates;
    protected JCheckBox enableLogging;
    protected JTextField loggingFile;
    private final RacerProPreferences prefs = RacerProPreferences.getInstance();

    public void applyChanges() {
        this.prefs.setStartRacerEnabled(this.startRacerPro.isSelected());
        this.prefs.setIntegratedRacerEnabled(this.useIntegratedRacerPro.isSelected());
        this.prefs.setExternalRacerBinaryPath(this.binaryField.getText());
        if (this.localRacerPort.getText() != null && this.localRacerPort.getText().length() > 0) {
            this.prefs.setLocalRacerPort(Integer.valueOf(this.localRacerPort.getText()));
        }
        this.prefs.setRemoteRacerAddress(this.remoteRacerProAdress.getText());
        if (this.remoteRacerProPort.getText() != null && this.remoteRacerProPort.getText().length() > 0) {
            this.prefs.setRemoteRacerPort(Integer.valueOf(this.remoteRacerProPort.getText()));
        }
        this.prefs.setAutoUpdateEnabled(this.checkForUpdates.isSelected());
        this.prefs.setLoggingDirectory(this.loggingFile.getText());
        this.prefs.setLoggingEnabled(this.enableLogging.isSelected());
    }

    public void initialise() throws Exception {
        JComponent jComponent = this.createBinaryPanel();
        this.setLayout(new BoxLayout((Container)((Object)this), 3));
        this.add(jComponent);
        this.add(this.createDisposeReasonerOnClosePanel());
        this.add(this.createOverwriteReasonerConfiguration());
    }

    public void dispose() throws Exception {
    }

    protected JComponent createAutoUpdatePanel() {
        JComponent jComponent = this.createPane(null, 3);
        JCheckBox jCheckBox = new JCheckBox("Check for RacerPro updates");
        jCheckBox.setSelected(this.prefs.isAutoUpdateEnabled());
        jCheckBox.setActionCommand("autoupdate");
        jCheckBox.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(jCheckBox);
        jComponent.add(jPanel);
        return jComponent;
    }

    protected JComponent createDisposeReasonerOnClosePanel() {
        JComponent jComponent = this.createPane("General configuration", 3);
        JCheckBox jCheckBox = new JCheckBox("Don't dispose Racer KB on reasoner dispose");
        jCheckBox.setAlignmentX(0.0f);
        jCheckBox.setAlignmentX(0.0f);
        jCheckBox.setToolTipText("Enable this option if the Racer KB should not be disposed.\nThis is useful if you want to inspect the KB with an external program such as RacerPorter.\n\nPlease note that you are responsible for the disposal of the KB!\n(This only applies to external Racer instances)");
        jCheckBox.setSelected(!this.prefs.isDisposeReasonerOnClose());
        jCheckBox.setActionCommand("disposeReasonerOnClose");
        jCheckBox.addActionListener(this);
        JComponent jComponent2 = this.createInfoPanel("If this option is enabled, knowledge bases are not disposed in RacerPro after switching the reasoner in Protege or after closing the ontology. Use this option only if you want to inspect the knowledge base with RacerPorter or a similar application and if you are running an external RacerPro instance that is neither started nor shutdowned automatically by Protege");
        jComponent2.setAlignmentX(0.0f);
        JCheckBox jCheckBox2 = new JCheckBox("Enable memory saving mode");
        jCheckBox2.setAlignmentX(0.0f);
        jCheckBox2.setSelected(this.prefs.isMemorySavingModeEnabled());
        jCheckBox2.setActionCommand("enableMemorySavingMode");
        jCheckBox2.addActionListener(this);
        JComponent jComponent3 = this.createInfoPanel("If this option is enabled, less memory is needed for ontologies in RacerPro but removing axioms might require to transfer the whole ontology to RacerPro");
        jComponent3.setAlignmentX(0.0f);
        Box box = new Box(1);
        jComponent.add(box);
        box.add(jCheckBox);
        box.add(jComponent2);
        box.add(jCheckBox2);
        box.add(jComponent3);
        return jComponent;
    }

    protected JComponent createOverwriteReasonerConfiguration() {
        JComponent jComponent = this.createPane("ABox Configuration", 3);
        RacerProPreferences racerProPreferences = new RacerProPreferences();
        JCheckBox jCheckBox = new JCheckBox("Disable ABox realization");
        jCheckBox.setSelected(racerProPreferences.isDisableABoxRealization());
        jCheckBox.setActionCommand("DisableABoxRealization");
        jCheckBox.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel();
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jLabel.setText("If this option is enabled, Protege Preferences for Reasoner initalization have no effect on ABox realization.");
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(jTextArea.getFont().deriveFont(2));
        jTextArea.setText("If this option is enabled, Protege Preferences for Reasoner initalization have no effect on ABox realization.");
        jTextArea.setEditable(false);
        jPanel2.add(jTextArea);
        jPanel.add(jPanel2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 35, 0, 0));
        JCheckBox jCheckBox2 = new JCheckBox("Disable ABox consistency checks");
        jCheckBox2.setSelected(racerProPreferences.isDisableABoxConsistencyTest());
        jCheckBox2.setActionCommand("DisableABoxConsistencyTest");
        jCheckBox2.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(jCheckBox);
        jPanel3.add(jPanel);
        jPanel3.add(jCheckBox2);
        jComponent.add(jPanel3);
        return jComponent;
    }

    protected JComponent createBinaryPanel() {
        JComponent jComponent = this.createPane("RacerPro", 3);
        this.startRacerPro = new JRadioButton("Start RacerPro automatically");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        this.localRacerPort = new JTextField();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel("Local Port"));
        jPanel2.add(this.localRacerPort);
        jPanel.add(jPanel2);
        RacerProPreferences racerProPreferences = new RacerProPreferences();
        this.useIntegratedRacerPro = RacerProInstalledBinaryInfo.getInstance().isBinaryFileAvailable() ? new JRadioButton("Use integrated RacerPro (" + RacerProInstalledBinaryInfo.getInstance().getInstalledBinaryVersion().toString() + ")") : new JRadioButton("Use integrated RacerPro ( Not Available!)");
        jPanel.add(this.useIntegratedRacerPro);
        this.useExternalRacerPro = new JRadioButton("Use external RacerPro");
        jPanel.add(this.useExternalRacerPro);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 35, 0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(Box.createHorizontalStrut(35));
        jPanel3.add(new JLabel("Binary"));
        this.binaryField = new JTextField();
        this.binaryField.setToolTipText("Specify the path to the RacerPro directory.");
        jPanel3.add(this.binaryField);
        JButton jButton = new JButton("...");
        jButton.addActionListener(this);
        jButton.setActionCommand("binaryFileChooser");
        jPanel3.add(jButton);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel4.setAlignmentX(0.0f);
        this.enableLogging = new JCheckBox("Enable logging");
        jPanel4.add(this.enableLogging);
        this.loggingFile = new JTextField(racerProPreferences.getLoggingDirectory());
        this.loggingFile.setToolTipText("Specify logging directory. Filename will automatically created using the current date (racer-YYYY-MM-DD.log");
        jPanel4.add(this.loggingFile);
        JButton jButton2 = new JButton("...");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("loggingFileChooser");
        jPanel4.add(jButton2);
        JButton jButton3 = new JButton("Reset to default");
        jButton3.setActionCommand("loggingFileReset");
        jButton3.addActionListener(this);
        jPanel4.add(jButton3);
        jPanel.add(jPanel4);
        this.connectRacerPro = new JRadioButton("Connect to running RacerPro");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 2));
        jPanel5.setAlignmentX(0.0f);
        jPanel5.add(Box.createHorizontalStrut(35));
        jPanel5.add(new JLabel("Remote Adress"));
        this.remoteRacerProAdress = new JTextField();
        jPanel5.add(this.remoteRacerProAdress);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 2));
        jPanel6.setAlignmentX(0.0f);
        jPanel6.add(Box.createHorizontalStrut(35));
        jPanel6.add(new JLabel("Remote Port"));
        this.remoteRacerProPort = new JTextField();
        jPanel6.add(this.remoteRacerProPort);
        this.checkForUpdates = new JCheckBox("Check for RacerPro binary updates");
        this.checkForUpdates.setSelected(true);
        this.checkForUpdates.setToolTipText("Check (and download if available) for newer version of Racer when starting Protege.");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 3));
        jPanel7.setAlignmentX(0.0f);
        jPanel7.add(this.startRacerPro);
        jPanel7.add(jPanel);
        jPanel7.add(this.connectRacerPro);
        jPanel7.add(jPanel5);
        jPanel7.add(jPanel6);
        jComponent.add(jPanel7);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.startRacerPro);
        buttonGroup.add(this.connectRacerPro);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.useIntegratedRacerPro);
        buttonGroup2.add(this.useExternalRacerPro);
        if (racerProPreferences.isStartRacerEnabled()) {
            this.startRacerPro.setSelected(true);
            this.localRacerPort.setEnabled(true);
            this.useIntegratedRacerPro.setEnabled(true);
            this.useExternalRacerPro.setEnabled(true);
            this.remoteRacerProAdress.setEnabled(false);
            this.remoteRacerProPort.setEnabled(false);
            this.loggingFile.setEnabled(true);
            this.enableLogging.setEnabled(true);
        } else {
            this.localRacerPort.setEnabled(false);
            this.binaryField.setEnabled(false);
            this.useIntegratedRacerPro.setEnabled(false);
            this.useExternalRacerPro.setEnabled(false);
            this.connectRacerPro.setSelected(true);
            this.remoteRacerProAdress.setEnabled(true);
            this.remoteRacerProPort.setEnabled(true);
            this.enableLogging.setEnabled(false);
        }
        if (racerProPreferences.isIntegratedRacerEnabled()) {
            this.useIntegratedRacerPro.setSelected(true);
            this.useExternalRacerPro.setSelected(false);
            if (this.useIntegratedRacerPro.isEnabled()) {
                this.binaryField.setEnabled(false);
            }
        } else {
            this.useExternalRacerPro.setSelected(true);
            this.useIntegratedRacerPro.setSelected(false);
            if (this.useExternalRacerPro.isEnabled()) {
                this.binaryField.setEnabled(true);
            }
        }
        this.enableLogging.setSelected(racerProPreferences.isLoggingEnabled());
        this.loggingFile.setEnabled(racerProPreferences.isLoggingEnabled() && racerProPreferences.isStartRacerEnabled());
        this.remoteRacerProAdress.setText(racerProPreferences.getRemoteRacerAddress());
        this.remoteRacerProPort.setText("" + racerProPreferences.getRemoteRacerPort());
        this.localRacerPort.setText("" + racerProPreferences.getLocalRacerPort());
        this.binaryField.setText(racerProPreferences.getExternalRacerBinaryPath());
        this.loggingFile.setText(racerProPreferences.getLoggingDirectory());
        this.startRacerPro.addActionListener(this);
        this.connectRacerPro.addActionListener(this);
        this.useIntegratedRacerPro.addActionListener(this);
        this.useExternalRacerPro.addActionListener(this);
        this.checkForUpdates.addActionListener(this);
        this.enableLogging.addActionListener(this);
        return jComponent;
    }

    private JComponent createInfoPanel(String string) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFont(jTextArea.getFont().deriveFont(2));
        jTextArea.setText(string);
        jTextArea.setEditable(false);
        jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 35, 0, 0));
        return jTextArea;
    }

    private JComponent createPane(String string, int n) {
        Box box = new Box(n){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
            }
        };
        box.setAlignmentX(0.0f);
        if (string != null) {
            box.setBorder(ComponentFactory.createTitledBorder((String)string));
        }
        return box;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent;
        if (this.startRacerPro.isSelected()) {
            this.localRacerPort.setEnabled(true);
            this.useIntegratedRacerPro.setEnabled(true);
            this.useExternalRacerPro.setEnabled(true);
            this.remoteRacerProAdress.setEnabled(false);
            this.remoteRacerProPort.setEnabled(false);
            this.binaryField.setEnabled(this.useExternalRacerPro.isSelected());
            this.enableLogging.setEnabled(true);
            this.loggingFile.setEnabled(true);
        } else {
            this.remoteRacerProAdress.setEnabled(true);
            this.remoteRacerProPort.setEnabled(true);
            this.useIntegratedRacerPro.setEnabled(false);
            this.useExternalRacerPro.setEnabled(false);
            this.binaryField.setEnabled(false);
            this.localRacerPort.setEnabled(false);
            this.loggingFile.setEnabled(false);
            this.enableLogging.setEnabled(false);
        }
        if (this.useIntegratedRacerPro.isSelected()) {
            this.binaryField.setEnabled(false);
        } else {
            this.binaryField.setEnabled(this.useExternalRacerPro.isEnabled());
        }
        this.loggingFile.setEnabled(this.prefs.isLoggingEnabled() && this.prefs.isStartRacerEnabled());
        this.loggingFile.setEnabled(this.enableLogging.isSelected());
        if ("autoupdate".equals(actionEvent.getActionCommand())) {
            jComponent = (AbstractButton)actionEvent.getSource();
            this.prefs.setAutoUpdateEnabled(((AbstractButton)jComponent).getModel().isSelected());
        } else if ("disposeReasonerOnClose".equals(actionEvent.getActionCommand())) {
            jComponent = (AbstractButton)actionEvent.getSource();
            this.prefs.setDisposeReasonerOnClose(!((AbstractButton)jComponent).getModel().isSelected());
        }
        if ("DisableABoxRealization".equals(actionEvent.getActionCommand())) {
            jComponent = (AbstractButton)actionEvent.getSource();
            this.prefs.setDisableABoxRealization(((AbstractButton)jComponent).getModel().isSelected());
        }
        if ("DisableABoxConsistencyTest".equals(actionEvent.getActionCommand())) {
            jComponent = (AbstractButton)actionEvent.getSource();
            this.prefs.setDisableABoxConsistencyTest(((AbstractButton)jComponent).getModel().isSelected());
        }
        if ("binaryFileChooser".equals(actionEvent.getActionCommand())) {
            jComponent = new JFileChooser(this.adjustBinaryFilePath(this.prefs.getExternalRacerBinaryPath()));
            jComponent = new JFileChooser();
            ((JFileChooser)jComponent).setMultiSelectionEnabled(false);
            ((JFileChooser)jComponent).setFileSelectionMode(1);
            ((JFileChooser)jComponent).setAcceptAllFileFilterUsed(false);
            RacerProInstalledBinaryInfo.OSTYPE oSTYPE = RacerProInstalledBinaryInfo.getInstance().getOSType();
            ((JFileChooser)jComponent).resetChoosableFileFilters();
            ((JFileChooser)jComponent).removeChoosableFileFilter(((JFileChooser)jComponent).getAcceptAllFileFilter());
            ((JFileChooser)jComponent).addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }

                public String getDescription() {
                    if (RacerProInstalledBinaryInfo.getInstance().getOSType() == RacerProInstalledBinaryInfo.OSTYPE.WIN) {
                        return "RacerPro folder";
                    }
                    return "RacerPro directory";
                }
            });
            if (RacerProInstalledBinaryInfo.getInstance().getOSType() == RacerProInstalledBinaryInfo.OSTYPE.WIN) {
                ((JFileChooser)jComponent).setDialogTitle("Choose RacerPro folder");
            } else {
                ((JFileChooser)jComponent).setDialogTitle("Choose RacerPro directory");
            }
            if (0 == ((JFileChooser)jComponent).showDialog((Component)((Object)this), null)) {
                String string = ((JFileChooser)jComponent).getSelectedFile().toString();
                String string2 = string + File.separator;
                switch (oSTYPE) {
                    case WIN: {
                        string2 = string2 + "RacerPro.exe";
                        break;
                    }
                    case MAC: {
                        string2 = string2 + "RacerPro";
                        break;
                    }
                    case OTHER: 
                    case LINUX: {
                        string2 = string2 + "RacerPro";
                    }
                }
                File file = new File(string2);
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(null, "The given directory does not contain a racer file", "Racer binary not found", 0);
                } else {
                    this.binaryField.setText(string);
                    this.prefs.setExternalRacerBinaryPath(string);
                }
            }
        } else if ("loggingFileChooser".equals(actionEvent.getActionCommand())) {
            jComponent = new JFileChooser(this.prefs.getLoggingDirectory());
            ((JFileChooser)jComponent).setFileSelectionMode(1);
            ((JFileChooser)jComponent).setAcceptAllFileFilterUsed(false);
            ((JFileChooser)jComponent).setMultiSelectionEnabled(false);
            ((JFileChooser)jComponent).setDialogTitle("Choose logging directory");
            ((JFileChooser)jComponent).setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }

                public String getDescription() {
                    if (RacerProInstalledBinaryInfo.getInstance().getOSType() == RacerProInstalledBinaryInfo.OSTYPE.WIN) {
                        return "folder";
                    }
                    return "directory";
                }
            });
            if (0 == ((JFileChooser)jComponent).showDialog((Component)((Object)this), null)) {
                this.loggingFile.setText(((JFileChooser)jComponent).getSelectedFile().toString());
                this.prefs.setLoggingDirectory(((JFileChooser)jComponent).getSelectedFile().toString());
            }
        } else if ("loggingFileReset".equals(actionEvent.getActionCommand())) {
            this.loggingFile.setText(this.prefs.getDefaultLoggingDirectory());
            this.prefs.setLoggingDirectory(this.prefs.getDefaultLoggingDirectory());
        } else if ("enableMemorySavingMode".equals(actionEvent.getActionCommand())) {
            jComponent = (AbstractButton)actionEvent.getSource();
            this.prefs.setEnableMemorySavingMode(((AbstractButton)jComponent).getModel().isSelected());
        }
    }

    protected String adjustBinaryFilePath(String string) {
        String string2 = File.separator;
        int n = string.lastIndexOf(string2);
        if (n > -1) {
            string = string.substring(0, n);
        }
        return string;
    }
}

