/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.protege.preferences;

import com.racersystems.protege.RacerProInstalledBinaryInfo;
import java.io.File;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class RacerProPreferences {
    private static RacerProPreferences instance;
    private static final String KEY = "com.racersystems.protege";
    private static final String BINARY = "binary";
    private static final String PORT = "port";
    private static final String LOGGING = "loggingEnabled";
    private static final String LOGGING_FILE = "logging";
    private static final String UNSAFE_MODE = "unsafeMode";
    private static final String UTF8 = "utf8";
    private static final String AUTO_UPDATE = "autoupdate";
    private static final String START_RACER_ENABLED_KEY = "startRacerEnabled";
    private static final String INTEGRATED_RACER_ENABLED_KEY = "integratedRacerEnabled";
    private static final String EXTERNAL_RACER_BINARY_PATH_KEY = "externalRacerBinaryPath";
    private static final String REMOTE_RACER_ADDRESS_KEY = "remoteRacerAddress";
    private static final String REMOTE_RACER_PORT_KEY = "removeRacerPort";
    private static final String LOCAL_RACER_PORT_KEY = "localRacerPort";
    private static final String DISPOSE_REASONER_ON_CLOSE = "disposeReasonerOnClose";
    private static final String DISABLE_ABOX_REALIZATION = "disableABoxRealization";
    private static final String DISABLE_ABOX_CONSISTENCY_TEST = "disableABoxConsistencyTest";
    private static final String ENABLE_MEMORY_SAVING_MODE = "enableMemorySavingMode";

    public static synchronized RacerProPreferences getInstance() {
        if (instance == null) {
            instance = new RacerProPreferences();
        }
        return instance;
    }

    private Preferences getPrefs() {
        return PreferencesManager.getInstance().getApplicationPreferences(KEY);
    }

    public String getDirectory() {
        return this.getPrefs().getString(BINARY, "");
    }

    public void setDirectory(String string) {
        this.getPrefs().putString(BINARY, string);
    }

    public int getPort() {
        return this.getPrefs().getInt(PORT, 8088);
    }

    public void setPort(int n) {
        this.getPrefs().putInt(PORT, n);
    }

    public void setLoggingEnabled(boolean bl) {
        this.getPrefs().putBoolean(LOGGING, bl);
    }

    public boolean isLoggingEnabled() {
        return this.getPrefs().getBoolean(LOGGING, false);
    }

    public void setLoggingDirectory(String string) {
        if (string == null) {
            string = "";
        }
        this.getPrefs().putString(LOGGING_FILE, string);
    }

    public String getLoggingDirectory() {
        String string = new String(this.getPrefs().getString(LOGGING_FILE, ""));
        if (string == null || string == "" || string.replace(" ", "").length() == 0) {
            return this.getDefaultLoggingDirectory();
        }
        return string;
    }

    public String getDefaultLoggingDirectory() {
        switch (RacerProInstalledBinaryInfo.getInstance().getOSType()) {
            case MAC: {
                String string = System.getProperty("user.home");
                if (string == null || string.length() <= 0) break;
                File file = new File(string = string + File.separator + "Library" + File.separator + "Logs" + File.separator + "RacerPro");
                if (!file.exists()) {
                    try {
                        file.mkdir();
                        return string;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return string;
            }
            case WIN: {
                String string = System.getProperty("user.home");
                if (string == null || string.length() <= 0) break;
                File file = new File(string = string + File.separator + "RacerPro" + File.separator + "Logs");
                if (!file.exists()) {
                    try {
                        file.mkdir();
                        return string;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return string;
            }
            case LINUX: {
                String string = System.getProperty("user.home");
                if (string == null || string.length() <= 0) break;
                File file = new File(string = string + File.separator + "RacerPro" + File.separator + "log");
                if (!file.exists()) {
                    try {
                        file.mkdir();
                        return string;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return string;
            }
        }
        return RacerProInstalledBinaryInfo.getInstance().getBinaryInstallationDirectory().getParent();
    }

    public void setUnsafeModeEnabled(boolean bl) {
        this.getPrefs().putBoolean(UNSAFE_MODE, bl);
    }

    public boolean isUnsafeModeEnabled() {
        return this.getPrefs().getBoolean(UNSAFE_MODE, false);
    }

    public void setUTF8(boolean bl) {
        this.getPrefs().putBoolean(UTF8, bl);
    }

    public boolean isUTF8() {
        return this.getPrefs().getBoolean(UTF8, true);
    }

    public boolean isAutoUpdateEnabled() {
        return this.getPrefs().getBoolean(AUTO_UPDATE, true);
    }

    public void setAutoUpdateEnabled(boolean bl) {
        this.getPrefs().putBoolean(AUTO_UPDATE, bl);
    }

    public boolean isStartRacerEnabled() {
        return this.getPrefs().getBoolean(START_RACER_ENABLED_KEY, true);
    }

    public void setStartRacerEnabled(boolean bl) {
        this.getPrefs().putBoolean(START_RACER_ENABLED_KEY, bl);
    }

    public boolean isIntegratedRacerEnabled() {
        return this.getPrefs().getBoolean(INTEGRATED_RACER_ENABLED_KEY, true);
    }

    public void setIntegratedRacerEnabled(boolean bl) {
        this.getPrefs().putBoolean(INTEGRATED_RACER_ENABLED_KEY, bl);
    }

    public String getExternalRacerBinaryPath() {
        return this.getPrefs().getString(EXTERNAL_RACER_BINARY_PATH_KEY, RacerProInstalledBinaryInfo.getInstance().getBinaryAbsoluteFile().getAbsolutePath());
    }

    public void setExternalRacerBinaryPath(String string) {
        RacerProInstalledBinaryInfo.OSTYPE oSTYPE = RacerProInstalledBinaryInfo.getInstance().getOSType();
        switch (oSTYPE) {
            case WIN: {
                if (string.endsWith(File.separator + "RacerPro.exe")) break;
                string = string + File.separator + "RacerPro.exe";
                break;
            }
            case MAC: {
                if (string.endsWith(File.separator + "RacerPro")) break;
                string = string + File.separator + "RacerPro";
                break;
            }
            case LINUX: 
            case OTHER: {
                if (string.endsWith(File.separator + "RacerPro")) break;
                string = string + File.separator + "RacerPro";
            }
        }
        this.getPrefs().putString(EXTERNAL_RACER_BINARY_PATH_KEY, string);
    }

    public String getRemoteRacerAddress() {
        return this.getPrefs().getString(REMOTE_RACER_ADDRESS_KEY, "127.0.0.1");
    }

    public void setRemoteRacerAddress(String string) {
        this.getPrefs().putString(REMOTE_RACER_ADDRESS_KEY, string);
    }

    public int getRemoteRacerPort() {
        return this.getPrefs().getInt(REMOTE_RACER_PORT_KEY, 8088);
    }

    public void setRemoteRacerPort(int n) {
        this.getPrefs().putInt(REMOTE_RACER_PORT_KEY, n);
    }

    public int getLocalRacerPort() {
        return this.getPrefs().getInt(LOCAL_RACER_PORT_KEY, 8088);
    }

    public void setLocalRacerPort(int n) {
        this.getPrefs().putInt(LOCAL_RACER_PORT_KEY, n);
    }

    public void setDisposeReasonerOnClose(boolean bl) {
        this.getPrefs().putBoolean(DISPOSE_REASONER_ON_CLOSE, bl);
    }

    public boolean isDisposeReasonerOnClose() {
        return this.getPrefs().getBoolean(DISPOSE_REASONER_ON_CLOSE, false);
    }

    public void setDisableABoxRealization(boolean bl) {
        this.getPrefs().putBoolean(DISABLE_ABOX_REALIZATION, bl);
    }

    public boolean isDisableABoxRealization() {
        return this.getPrefs().getBoolean(DISABLE_ABOX_REALIZATION, true);
    }

    public void setDisableABoxConsistencyTest(boolean bl) {
        this.getPrefs().putBoolean(DISABLE_ABOX_CONSISTENCY_TEST, bl);
    }

    public boolean isDisableABoxConsistencyTest() {
        return this.getPrefs().getBoolean(DISABLE_ABOX_CONSISTENCY_TEST, true);
    }

    public void setEnableMemorySavingMode(boolean bl) {
        this.getPrefs().putBoolean(ENABLE_MEMORY_SAVING_MODE, bl);
    }

    public boolean isMemorySavingModeEnabled() {
        return this.getPrefs().getBoolean(ENABLE_MEMORY_SAVING_MODE, false);
    }
}

