/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.protege.update;

import com.racersystems.protege.RacerProInstalledBinaryInfo;
import com.racersystems.protege.update.RacerProUpdateInfo;
import com.racersystems.protege.update.UpdateInstaller;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class UpdateChecker {
    private static final String UPDATE_URL_KEY = "racer-bin-update-URL";
    private static final String REQUIRED_VERSION_KEY = "required-racer-version";
    protected URL updateInfoLocationURL;
    protected Version requiredVersion;

    public UpdateChecker(Bundle bundle) {
        String string = (String)bundle.getHeaders().get(UPDATE_URL_KEY);
        try {
            this.updateInfoLocationURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        String string2 = (String)bundle.getHeaders().get(REQUIRED_VERSION_KEY);
        this.requiredVersion = string2 != null ? Version.parseVersion((String)string2) : Version.parseVersion((String)"2.0.0");
    }

    public boolean checkForRemoteUpdate() throws Exception {
        RacerProUpdateInfo racerProUpdateInfo = RacerProUpdateInfo.read(this.updateInfoLocationURL);
        RacerProInstalledBinaryInfo racerProInstalledBinaryInfo = RacerProInstalledBinaryInfo.getInstance();
        if (racerProUpdateInfo == null || racerProInstalledBinaryInfo == null) {
            return false;
        }
        if (racerProInstalledBinaryInfo.isBinaryFileAvailable() && racerProInstalledBinaryInfo.getInstalledBinaryVersion() != null && racerProUpdateInfo.getAvailableVersion().compareTo((Object)racerProInstalledBinaryInfo.getInstalledBinaryVersion()) <= 0) {
            return false;
        }
        UpdateInstaller updateInstaller = new UpdateInstaller();
        updateInstaller.downloadFile(racerProUpdateInfo);
        return true;
    }

    public boolean checkForUpdate() throws Exception {
        RacerProInstalledBinaryInfo racerProInstalledBinaryInfo = RacerProInstalledBinaryInfo.getInstance();
        if (racerProInstalledBinaryInfo == null) {
            return false;
        }
        if (racerProInstalledBinaryInfo.isBinaryFileAvailable()) {
            if (this.requiredVersion.compareTo((Object)racerProInstalledBinaryInfo.getInstalledBinaryVersion()) <= 0) {
                return false;
            }
            if (1 == JOptionPane.showConfirmDialog(null, "The installed RacerPro binary files are outdated.\nDo you want to download a new version now?\n(Otherwise you can only use an external RacerPro binary file.)", "RacerPro Plugin", 0)) {
                return false;
            }
        } else if (1 == JOptionPane.showConfirmDialog(null, "No RacerPro reasoner file is installed.\nDo you want to download the reasoner file now?", "RacerPro Plugin", 0)) {
            return false;
        }
        try {
            RacerProUpdateInfo racerProUpdateInfo = RacerProUpdateInfo.read(this.updateInfoLocationURL);
            if (racerProUpdateInfo.getAvailableVersion().compareTo((Object)this.requiredVersion) < 0) {
                System.out.println("remoteInfo " + racerProUpdateInfo.getAvailableVersion() + " < required info " + this.requiredVersion);
                JOptionPane.showMessageDialog(null, "No valid RacerPro binary file could be found.\nPlease contact racersystems.", "No valid RacerPro binary file", 0);
                return false;
            }
            UpdateInstaller updateInstaller = new UpdateInstaller();
            updateInstaller.downloadFile(racerProUpdateInfo);
        }
        catch (InterruptedIOException interruptedIOException) {
            JOptionPane.showMessageDialog(null, "Installation of Racer binary has been cancelled by the user", "RacerPro installation cancelled", 0);
            throw interruptedIOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, "Racer could not be downloaded or installed.\nPlease check your network connection.\nPlease also check whether you have write access to the P4 plugin folder (try running P4 as administrator).", "RacerPro download error", 0);
            throw exception;
        }
        return true;
    }
}

