/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.racer;

import com.racersystems.racer.AxiomLoadingStrategy;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class Configuration
implements Cloneable,
Serializable,
OWLReasonerConfiguration {
    private ReasonerProgressMonitor progressMonitor;
    private FreshEntityPolicy freshEntityPolicy;
    private IndividualNodeSetPolicy individualNodeSetPolicy;
    private long timeOut;
    private InetSocketAddress address;
    private boolean isAnnotationConsidered;
    private AxiomLoadingStrategy axiomLoadingStrategy;
    private boolean disableABoxConsistencyTest;
    private boolean isMemorySavingMode;

    public Configuration() {
        this(new InetSocketAddress("127.0.0.1", 8088));
    }

    public Configuration(InetSocketAddress inetSocketAddress, ReasonerProgressMonitor reasonerProgressMonitor) {
        this(inetSocketAddress);
        this.progressMonitor = reasonerProgressMonitor;
    }

    public Configuration(InetSocketAddress inetSocketAddress) {
        this.address = inetSocketAddress;
        this.progressMonitor = new NullReasonerProgressMonitor();
        this.freshEntityPolicy = FreshEntityPolicy.ALLOW;
        this.individualNodeSetPolicy = IndividualNodeSetPolicy.BY_NAME;
        this.timeOut = Long.MAX_VALUE;
        this.axiomLoadingStrategy = AxiomLoadingStrategy.LOAD_ON_CREATION;
        this.disableABoxConsistencyTest = false;
        this.isMemorySavingMode = false;
    }

    public Configuration(OWLReasonerConfiguration oWLReasonerConfiguration) {
        this();
        this.progressMonitor = oWLReasonerConfiguration.getProgressMonitor();
        this.freshEntityPolicy = oWLReasonerConfiguration.getFreshEntityPolicy();
        this.individualNodeSetPolicy = oWLReasonerConfiguration.getIndividualNodeSetPolicy();
        this.timeOut = oWLReasonerConfiguration.getTimeOut();
        if (oWLReasonerConfiguration instanceof Configuration) {
            Configuration configuration = (Configuration)oWLReasonerConfiguration;
            this.address = configuration.address;
            this.isAnnotationConsidered = configuration.isAnnotationConsidered;
            this.axiomLoadingStrategy = configuration.axiomLoadingStrategy;
            this.disableABoxConsistencyTest = configuration.disableABoxConsistencyTest;
            this.isMemorySavingMode = configuration.isMemorySavingMode;
        }
    }

    public Configuration clone() {
        try {
            Configuration configuration = (Configuration)super.clone();
            return configuration;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new Configuration();
        }
    }

    public static Configuration clone(OWLReasonerConfiguration oWLReasonerConfiguration) {
        Configuration configuration = new Configuration();
        configuration.progressMonitor = oWLReasonerConfiguration.getProgressMonitor();
        configuration.freshEntityPolicy = oWLReasonerConfiguration.getFreshEntityPolicy();
        configuration.individualNodeSetPolicy = oWLReasonerConfiguration.getIndividualNodeSetPolicy();
        configuration.timeOut = oWLReasonerConfiguration.getTimeOut();
        if (oWLReasonerConfiguration instanceof Configuration) {
            Configuration configuration2 = (Configuration)oWLReasonerConfiguration;
            configuration.address = configuration2.address;
            configuration.isAnnotationConsidered = configuration2.isAnnotationConsidered;
            configuration.axiomLoadingStrategy = configuration2.axiomLoadingStrategy;
            configuration.disableABoxConsistencyTest = configuration2.disableABoxConsistencyTest;
            configuration.isMemorySavingMode = configuration2.isMemorySavingMode;
        }
        return configuration;
    }

    public void setAxiomLoadingStrategy(AxiomLoadingStrategy axiomLoadingStrategy) {
        this.axiomLoadingStrategy = axiomLoadingStrategy;
    }

    public AxiomLoadingStrategy getAxiomLoadingStrategy() {
        return this.axiomLoadingStrategy;
    }

    public void setMemorySavingModeEnabled(boolean bl) {
        this.isMemorySavingMode = bl;
    }

    public boolean isMemorySavingModeEnabled() {
        return this.isMemorySavingMode;
    }

    public void setAboxConsistencyTestEnabled(boolean bl) {
        this.disableABoxConsistencyTest = !bl;
    }

    public boolean isAboxConsistencyTestEnabled() {
        return !this.disableABoxConsistencyTest;
    }

    public InetSocketAddress getSocketAddress() {
        return this.address;
    }

    public ReasonerProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setReasonerProgressMonitor(ReasonerProgressMonitor reasonerProgressMonitor) {
        this.progressMonitor = reasonerProgressMonitor;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.freshEntityPolicy;
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.individualNodeSetPolicy;
    }
}

