/*
 * Decompiled with CFR 0.152.
 */
package com.racersystems.racer;

import com.racersystems.racer.util.NonShortFormProvider;
import com.racersystems.racer.util.RacerPrefixManager;
import com.racersystems.racer.util.ShortFormProvider;
import java.io.IOException;
import java.io.Writer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualVisitor;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitor;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class DescriptionRenderer
implements OWLClassExpressionVisitor,
OWLPropertyExpressionVisitor,
OWLDataVisitor,
OWLNamedObjectVisitor,
OWLIndividualVisitor {
    protected final ShortFormProvider shortFormProvider;
    private final Writer writer;
    RacerPrefixManager manager;

    public DescriptionRenderer(Writer writer) {
        this(new RacerPrefixManager(), writer, new NonShortFormProvider());
    }

    public DescriptionRenderer(RacerPrefixManager racerPrefixManager, Writer writer, ShortFormProvider shortFormProvider) {
        this.writer = writer;
        this.shortFormProvider = shortFormProvider;
        this.manager = racerPrefixManager;
    }

    public ShortFormProvider getShortFormProvider() {
        return this.shortFormProvider;
    }

    protected final void writeS(IRI iRI) throws IOException {
        this.writer.write(" ");
        this.writer.write(this.shortFormProvider.shortForm(iRI));
    }

    protected final void writeS(String string) throws IOException {
        this.writer.write(" ");
        this.writer.write(string);
    }

    private void writeS(int n) throws IOException {
        this.writer.write(" ");
        this.writer.write(String.valueOf(n));
    }

    protected final void write(String string) throws IOException {
        this.writer.write(string);
    }

    public final void writeOpenPar() throws IOException {
        this.writer.write("(");
    }

    public final void writeClosePar() throws IOException {
        this.writer.write(")");
    }

    public final void write(OWLClassExpression oWLClassExpression) throws IOException {
        this.write(" ");
        oWLClassExpression.accept((OWLClassExpressionVisitor)this);
    }

    public final void write(OWLNamedIndividual oWLNamedIndividual) throws IOException {
        this.write(" ");
        oWLNamedIndividual.accept((OWLIndividualVisitor)this);
    }

    public final void write(OWLAnonymousIndividual oWLAnonymousIndividual) throws IOException {
        this.write(" ");
        oWLAnonymousIndividual.accept((OWLIndividualVisitor)this);
    }

    public final void write(OWLIndividual oWLIndividual) throws IOException {
        if (oWLIndividual.isAnonymous()) {
            this.write(oWLIndividual.asOWLAnonymousIndividual());
        } else {
            this.write(oWLIndividual.asOWLNamedIndividual());
        }
    }

    public final void write(OWLPropertyExpression oWLPropertyExpression) throws IOException {
        this.write(" ");
        oWLPropertyExpression.accept((OWLPropertyExpressionVisitor)this);
    }

    public final void write(OWLAnnotationProperty oWLAnnotationProperty) throws IOException {
        this.write(" ");
        oWLAnnotationProperty.accept((OWLNamedObjectVisitor)this);
    }

    public final void write(OWLDataRange oWLDataRange) throws IOException {
        this.write(" ");
        oWLDataRange.accept((OWLDataVisitor)this);
    }

    public final void visit(OWLClass oWLClass) {
        try {
            this.writeS(oWLClass.getIRI());
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLDataProperty oWLDataProperty) {
        try {
            this.writeS(oWLDataProperty.getIRI());
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLObjectProperty oWLObjectProperty) {
        try {
            this.writeS(oWLObjectProperty.getIRI());
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public void visit(OWLNamedIndividual oWLNamedIndividual) {
        try {
            this.writeS(oWLNamedIndividual.getIRI());
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public void visit(OWLAnonymousIndividual oWLAnonymousIndividual) {
        try {
            this.writeS(oWLAnonymousIndividual.getID().getID());
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLObjectMinCardinality oWLObjectMinCardinality) {
        try {
            this.writeOpenPar();
            this.write("at-least");
            this.writeS(oWLObjectMinCardinality.getCardinality());
            this.write(oWLObjectMinCardinality.getProperty());
            if (oWLObjectMinCardinality.isQualified()) {
                this.write((OWLClassExpression)oWLObjectMinCardinality.getFiller());
            }
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLObjectMaxCardinality oWLObjectMaxCardinality) {
        try {
            this.writeOpenPar();
            this.write("at-most");
            this.writeS(oWLObjectMaxCardinality.getCardinality());
            this.write(oWLObjectMaxCardinality.getProperty());
            if (oWLObjectMaxCardinality.isQualified()) {
                this.write((OWLClassExpression)oWLObjectMaxCardinality.getFiller());
            }
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLObjectExactCardinality oWLObjectExactCardinality) {
        try {
            this.writeOpenPar();
            this.write("exactly");
            this.writeS(oWLObjectExactCardinality.getCardinality());
            this.write(oWLObjectExactCardinality.getProperty());
            if (oWLObjectExactCardinality.isQualified()) {
                this.write((OWLClassExpression)oWLObjectExactCardinality.getFiller());
            }
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLObjectAllValuesFrom oWLObjectAllValuesFrom) {
        try {
            this.writeOpenPar();
            this.write("all");
            this.write(oWLObjectAllValuesFrom.getProperty());
            this.write((OWLClassExpression)oWLObjectAllValuesFrom.getFiller());
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom) {
        try {
            this.writeOpenPar();
            this.write("some");
            this.write(oWLObjectSomeValuesFrom.getProperty());
            this.write((OWLClassExpression)oWLObjectSomeValuesFrom.getFiller());
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLDataExactCardinality oWLDataExactCardinality) {
        try {
            this.writeOpenPar();
            this.write("d-exactly");
            this.writeS(oWLDataExactCardinality.getCardinality());
            this.write(oWLDataExactCardinality.getProperty());
            if (oWLDataExactCardinality.isQualified()) {
                this.write((OWLDataRange)oWLDataExactCardinality.getFiller());
            }
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLDataMaxCardinality oWLDataMaxCardinality) {
        try {
            this.writeOpenPar();
            this.write("d-at-most");
            this.writeS(oWLDataMaxCardinality.getCardinality());
            this.write(oWLDataMaxCardinality.getProperty());
            if (oWLDataMaxCardinality.isQualified()) {
                this.write((OWLDataRange)oWLDataMaxCardinality.getFiller());
            }
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLDataMinCardinality oWLDataMinCardinality) {
        try {
            this.writeOpenPar();
            this.write("d-at-least");
            this.writeS(oWLDataMinCardinality.getCardinality());
            this.write(oWLDataMinCardinality.getProperty());
            if (oWLDataMinCardinality.isQualified()) {
                this.write((OWLDataRange)oWLDataMinCardinality.getFiller());
            }
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
        try {
            this.writeOpenPar();
            this.write("and");
            for (OWLClassExpression oWLClassExpression : oWLObjectIntersectionOf.getOperands()) {
                this.write(oWLClassExpression);
            }
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLObjectUnionOf oWLObjectUnionOf) {
        try {
            this.writeOpenPar();
            this.write("or");
            for (OWLClassExpression oWLClassExpression : oWLObjectUnionOf.getOperands()) {
                this.write(oWLClassExpression);
            }
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLObjectComplementOf oWLObjectComplementOf) {
        try {
            this.writeOpenPar();
            this.write("not");
            this.write(oWLObjectComplementOf.getOperand());
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLObjectInverseOf oWLObjectInverseOf) {
        try {
            this.writeOpenPar();
            this.write("inv");
            this.write((OWLPropertyExpression)oWLObjectInverseOf.getInverse());
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLDataHasValue oWLDataHasValue) {
        try {
            this.writeOpenPar();
            this.write("d-filler");
            ((OWLDataPropertyExpression)oWLDataHasValue.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            ((OWLLiteral)oWLDataHasValue.getValue()).accept((OWLDataVisitor)this);
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public final void visit(OWLObjectOneOf oWLObjectOneOf) {
        try {
            this.writeOpenPar();
            this.write("one-of");
            for (OWLIndividual oWLIndividual : oWLObjectOneOf.getIndividuals()) {
                if (oWLIndividual.isAnonymous()) {
                    this.write(oWLIndividual.asOWLAnonymousIndividual());
                    continue;
                }
                this.write(oWLIndividual.asOWLNamedIndividual());
            }
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public void visit(OWLOntology oWLOntology) {
    }

    public void visit(OWLDatatype oWLDatatype) {
        try {
            IRI iRI = oWLDatatype.getIRI();
            this.writeOpenPar();
            this.write("d-base-type");
            this.writeS(this.shortFormProvider.shortForm(iRI));
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public void visit(OWLDataComplementOf oWLDataComplementOf) {
        try {
            this.writeOpenPar();
            this.write("d-complement");
            oWLDataComplementOf.getDataRange().accept((OWLDataVisitor)this);
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public void visit(OWLDataOneOf oWLDataOneOf) {
        try {
            this.writeOpenPar();
            this.write("d-possible-values ");
            for (OWLLiteral oWLLiteral : oWLDataOneOf.getValues()) {
                oWLLiteral.accept((OWLDataVisitor)this);
            }
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public void visit(OWLDatatypeRestriction oWLDatatypeRestriction) {
        try {
            this.writeOpenPar();
            this.writeS("d-datarange");
            oWLDatatypeRestriction.getDatatype().accept((OWLDataVisitor)this);
            for (OWLFacetRestriction oWLFacetRestriction : oWLDatatypeRestriction.getFacetRestrictions()) {
                this.visit(oWLFacetRestriction);
            }
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public void visit(OWLFacetRestriction oWLFacetRestriction) {
        try {
            this.writeOpenPar();
            this.writeS("d-facet");
            this.writeS(this.shortFormProvider.shortForm(oWLFacetRestriction.getFacet().getIRI()));
            oWLFacetRestriction.getFacetValue().accept((OWLDataVisitor)this);
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public void visit(OWLDataAllValuesFrom oWLDataAllValuesFrom) {
        try {
            this.writeOpenPar();
            this.write("d-all");
            this.write(oWLDataAllValuesFrom.getProperty());
            this.write((OWLDataRange)oWLDataAllValuesFrom.getFiller());
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public void visit(OWLDataSomeValuesFrom oWLDataSomeValuesFrom) {
        try {
            this.writeOpenPar();
            this.write("d-some");
            this.write(oWLDataSomeValuesFrom.getProperty());
            this.write((OWLDataRange)oWLDataSomeValuesFrom.getFiller());
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    public void visit(OWLLiteral oWLLiteral) {
        try {
            this.writeOpenPar();
            this.write("d-literal");
            this.write(" ");
            this.write("\"");
            this.write(this.makePretty(oWLLiteral.getLiteral()));
            this.write("\"");
            this.write(" ");
            this.visit(oWLLiteral.getDatatype());
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }

    protected String makePretty(String string) {
        String string2 = string.replaceAll("\n", "\\\\N");
        return string2.replace("\"", "\\S");
    }

    public void visit(OWLDataIntersectionOf oWLDataIntersectionOf) {
    }

    public void visit(OWLDataUnionOf oWLDataUnionOf) {
    }

    public void visit(OWLAnnotationProperty oWLAnnotationProperty) {
    }

    public void visit(OWLObjectHasSelf oWLObjectHasSelf) {
    }

    public void visit(OWLObjectHasValue oWLObjectHasValue) {
        try {
            this.writeOpenPar();
            this.write("has-value");
            ((OWLObjectPropertyExpression)oWLObjectHasValue.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            ((OWLIndividual)oWLObjectHasValue.getValue()).accept((OWLIndividualVisitor)this);
            this.writeClosePar();
        }
        catch (IOException iOException) {
            throw new OWLRuntimeException((Throwable)iOException);
        }
    }
}

